/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.IRoleEntity;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.extensible.ExtensibleAttributes;
import buri.ddmsence.util.LazyList;
import buri.ddmsence.util.Util;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;

public abstract class AbstractRoleEntity
extends AbstractBaseComponent
implements IRoleEntity {
    private List<String> _names = null;
    private List<String> _phones = null;
    private List<String> _emails = null;
    private ExtensibleAttributes _extensibleAttributes = null;
    private static final String NAME_NAME = "name";
    private static final String PHONE_NAME = "phone";
    private static final String EMAIL_NAME = "email";

    protected AbstractRoleEntity(Element element, boolean bl) throws InvalidDDMSException {
        try {
            this._names = Util.getDDMSChildValues(element, NAME_NAME);
            this._phones = Util.getDDMSChildValues(element, PHONE_NAME);
            this._emails = Util.getDDMSChildValues(element, EMAIL_NAME);
            this._extensibleAttributes = new ExtensibleAttributes(element);
            this.setXOMElement(element, bl);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    protected AbstractRoleEntity(String string, List<String> list, List<String> list2, List<String> list3, ExtensibleAttributes extensibleAttributes, boolean bl) throws InvalidDDMSException {
        try {
            Util.requireDDMSValue("entityName", string);
            if (list == null) {
                list = Collections.emptyList();
            }
            if (list2 == null) {
                list2 = Collections.emptyList();
            }
            if (list3 == null) {
                list3 = Collections.emptyList();
            }
            Element element = Util.buildDDMSElement(string, null);
            for (String string2 : list) {
                element.appendChild((Node)Util.buildDDMSElement(NAME_NAME, string2));
            }
            for (String string2 : list2) {
                element.appendChild((Node)Util.buildDDMSElement(PHONE_NAME, string2));
            }
            for (String string2 : list3) {
                element.appendChild((Node)Util.buildDDMSElement(EMAIL_NAME, string2));
            }
            this._names = list;
            this._phones = list2;
            this._emails = list3;
            this._extensibleAttributes = ExtensibleAttributes.getNonNullInstance(extensibleAttributes);
            this._extensibleAttributes.addTo(element);
            this.setXOMElement(element, bl);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        if (this.getXOMElement().getChildElements(NAME_NAME, this.getNamespace()).size() == 0) {
            throw new InvalidDDMSException("At least 1 name element must exist.");
        }
        if (Util.containsOnlyEmptyValues(this.getNames())) {
            throw new InvalidDDMSException("At least 1 name element must have a non-empty value.");
        }
        super.validate();
    }

    @Override
    protected void validateWarnings() {
        Elements elements = this.getXOMElement().getChildElements(PHONE_NAME, this.getNamespace());
        for (int i = 0; i < elements.size(); ++i) {
            if (!Util.isEmpty(elements.get(i).getValue())) continue;
            this.addWarning("A ddms:phone element was found with no value.");
            break;
        }
        Elements elements2 = this.getXOMElement().getChildElements(EMAIL_NAME, this.getNamespace());
        for (int i = 0; i < elements2.size(); ++i) {
            if (!Util.isEmpty(elements2.get(i).getValue())) continue;
            this.addWarning("A ddms:email element was found with no value.");
            break;
        }
        super.validateWarnings();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof AbstractRoleEntity)) {
            return false;
        }
        AbstractRoleEntity abstractRoleEntity = (AbstractRoleEntity)object;
        return Util.listEquals(this.getNames(), abstractRoleEntity.getNames()) && Util.listEquals(this.getPhones(), abstractRoleEntity.getPhones()) && Util.listEquals(this.getEmails(), abstractRoleEntity.getEmails()) && this.getExtensibleAttributes().equals(abstractRoleEntity.getExtensibleAttributes());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.getNames().hashCode();
        n = 7 * n + this.getPhones().hashCode();
        n = 7 * n + this.getEmails().hashCode();
        n = 7 * n + this.getExtensibleAttributes().hashCode();
        return n;
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, "", string2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(AbstractRoleEntity.buildOutput(bl, string3 + "entityType", this.getName()));
        stringBuffer.append(this.buildOutput(bl, string3 + NAME_NAME, this.getNames()));
        stringBuffer.append(this.buildOutput(bl, string3 + PHONE_NAME, this.getPhones()));
        stringBuffer.append(this.buildOutput(bl, string3 + EMAIL_NAME, this.getEmails()));
        stringBuffer.append(this.getExtensibleAttributes().getOutput(bl, string));
        return stringBuffer.toString();
    }

    @Override
    public List<String> getNames() {
        return Collections.unmodifiableList(this._names);
    }

    @Override
    public List<String> getPhones() {
        return Collections.unmodifiableList(this._phones);
    }

    @Override
    public List<String> getEmails() {
        return Collections.unmodifiableList(this._emails);
    }

    @Override
    public ExtensibleAttributes getExtensibleAttributes() {
        return this._extensibleAttributes;
    }

    public static abstract class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = -1694935853087559491L;
        private List<String> _names;
        private List<String> _phones;
        private List<String> _emails;
        private ExtensibleAttributes.Builder _extensibleAttributes;

        protected Builder() {
        }

        protected Builder(AbstractRoleEntity abstractRoleEntity) {
            this.setNames(abstractRoleEntity.getNames());
            this.setPhones(abstractRoleEntity.getPhones());
            this.setEmails(abstractRoleEntity.getEmails());
            this.setExtensibleAttributes(new ExtensibleAttributes.Builder(abstractRoleEntity.getExtensibleAttributes()));
        }

        @Override
        public boolean isEmpty() {
            return Util.containsOnlyEmptyValues(this.getNames()) && Util.containsOnlyEmptyValues(this.getPhones()) && Util.containsOnlyEmptyValues(this.getEmails()) && this.getExtensibleAttributes().isEmpty();
        }

        public List<String> getNames() {
            if (this._names == null) {
                this._names = new LazyList(String.class);
            }
            return this._names;
        }

        public void setNames(List<String> list) {
            this._names = new LazyList(list, String.class);
        }

        public List<String> getPhones() {
            if (this._phones == null) {
                this._phones = new LazyList(String.class);
            }
            return this._phones;
        }

        public void setPhones(List<String> list) {
            this._phones = new LazyList(list, String.class);
        }

        public List<String> getEmails() {
            if (this._emails == null) {
                this._emails = new LazyList(String.class);
            }
            return this._emails;
        }

        public void setEmails(List<String> list) {
            this._emails = new LazyList(list, String.class);
        }

        public ExtensibleAttributes.Builder getExtensibleAttributes() {
            if (this._extensibleAttributes == null) {
                this._extensibleAttributes = new ExtensibleAttributes.Builder();
            }
            return this._extensibleAttributes;
        }

        public void setExtensibleAttributes(ExtensibleAttributes.Builder builder) {
            this._extensibleAttributes = builder;
        }
    }
}

