/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence;

import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.ValidationMessage;
import buri.ddmsence.util.DDMSVersion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractAttributeGroup {
    private String _xmlNamespace = null;
    private List<ValidationMessage> _warnings = null;

    public AbstractAttributeGroup(String string) {
        this._xmlNamespace = string;
    }

    public DDMSVersion getDDMSVersion() {
        return DDMSVersion.getVersionForNamespace(this._xmlNamespace);
    }

    protected void validate() throws InvalidDDMSException {
    }

    protected void validateSameVersion(DDMSVersion dDMSVersion) throws InvalidDDMSException {
        if (!this.getDDMSVersion().equals(dDMSVersion)) {
            throw new InvalidDDMSException("These attributes cannot decorate a component with a different DDMS version.");
        }
    }

    public List<ValidationMessage> getValidationWarnings() {
        return Collections.unmodifiableList(this.getWarnings());
    }

    protected List<ValidationMessage> getWarnings() {
        if (this._warnings == null) {
            this._warnings = new ArrayList<ValidationMessage>();
        }
        return this._warnings;
    }

    public abstract String getOutput(boolean var1, String var2);
}

