/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.IDDMSComponent;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.security.ism.SecurityAttributes;
import buri.ddmsence.ddms.security.ntk.SystemName;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.PropertyReader;
import buri.ddmsence.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import nu.xom.Element;
import nu.xom.Node;

public abstract class AbstractAccessEntity
extends AbstractBaseComponent {
    private SystemName _systemName = null;
    private SecurityAttributes _securityAttributes = null;

    public AbstractAccessEntity(Element element) throws InvalidDDMSException {
        this.setXOMElement(element, false);
        Element element2 = element.getFirstChildElement(SystemName.getName(this.getDDMSVersion()), this.getNamespace());
        if (element2 != null) {
            this._systemName = new SystemName(element2);
        }
        this._securityAttributes = new SecurityAttributes(element);
    }

    public AbstractAccessEntity(String string, SystemName systemName, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        DDMSVersion dDMSVersion = DDMSVersion.getCurrentVersion();
        Element element = Util.buildElement(PropertyReader.getPrefix("ntk"), string, dDMSVersion.getNtkNamespace(), null);
        this.setXOMElement(element, false);
        if (systemName != null) {
            element.appendChild((Node)systemName.getXOMElementCopy());
        }
        this._systemName = systemName;
        this._securityAttributes = SecurityAttributes.getNonNullInstance(securityAttributes);
        this._securityAttributes.addTo(element);
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireDDMSValue("systemName", this.getSystemName());
        Util.requireBoundedChildCount(this.getXOMElement(), SystemName.getName(this.getDDMSVersion()), 1, 1);
        Util.requireDDMSValue("security attributes", this.getSecurityAttributes());
        this.getSecurityAttributes().requireClassification();
        this.requireVersion("4.0.1");
        super.validate();
    }

    @Override
    protected List<IDDMSComponent> getNestedComponents() {
        ArrayList<IDDMSComponent> arrayList = new ArrayList<IDDMSComponent>();
        arrayList.add(this.getSystemName());
        return arrayList;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && object instanceof AbstractAccessEntity;
    }

    public SystemName getSystemName() {
        return this._systemName;
    }

    @Override
    public SecurityAttributes getSecurityAttributes() {
        return this._securityAttributes;
    }

    public static abstract class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = 7851044806424206976L;
        private SystemName.Builder _systemName;
        private SecurityAttributes.Builder _securityAttributes;

        public Builder() {
        }

        public Builder(AbstractAccessEntity abstractAccessEntity) {
            if (abstractAccessEntity.getSystemName() != null) {
                this.setSystemName(new SystemName.Builder(abstractAccessEntity.getSystemName()));
            }
            this.setSecurityAttributes(new SecurityAttributes.Builder(abstractAccessEntity.getSecurityAttributes()));
        }

        @Override
        public boolean isEmpty() {
            return this.getSystemName().isEmpty() && this.getSecurityAttributes().isEmpty();
        }

        public SystemName.Builder getSystemName() {
            if (this._systemName == null) {
                this._systemName = new SystemName.Builder();
            }
            return this._systemName;
        }

        public void setSystemName(SystemName.Builder builder) {
            this._systemName = builder;
        }

        public SecurityAttributes.Builder getSecurityAttributes() {
            if (this._securityAttributes == null) {
                this._securityAttributes = new SecurityAttributes.Builder();
            }
            return this._securityAttributes;
        }

        public void setSecurityAttributes(SecurityAttributes.Builder builder) {
            this._securityAttributes = builder;
        }
    }
}

