/*
 * Decompiled with CFR 0.152.
 */
package net.unit8.waitt.mojo.component;

import java.io.IOException;
import java.util.List;
import org.apache.maven.plugins.annotations.Component;
import org.codehaus.plexus.components.interactivity.InputHandler;
import org.codehaus.plexus.components.interactivity.OutputHandler;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;

public class WaittPrompter
implements Prompter {
    @Component
    private OutputHandler outputHandler;
    @Component
    private InputHandler inputHandler;

    public String prompt(String message) throws PrompterException {
        this.writePrompt(message);
        return this.readLine();
    }

    public String prompt(String message, String defaultReply) throws PrompterException {
        this.writePrompt(message);
        String line = this.readLine();
        if (line == null || line.isEmpty()) {
            line = defaultReply;
        }
        return line;
    }

    public String prompt(String message, List possibleValues) throws PrompterException {
        return this.prompt(message, possibleValues, null);
    }

    public String prompt(String message, List possibleValues, String defaultReply) throws PrompterException {
        String line;
        do {
            this.writePrompt(message);
            line = this.readLine();
            if (line == null || line.isEmpty()) {
                line = defaultReply;
            }
            if (line == null || possibleValues.contains(line)) continue;
            try {
                this.outputHandler.writeLine("Invalid selection.");
            }
            catch (IOException e) {
                throw new PrompterException("Failed to present feedback", (Throwable)e);
            }
        } while (line == null || !possibleValues.contains(line));
        return line;
    }

    public String promptForPassword(String message) throws PrompterException {
        this.writePrompt(message);
        try {
            return this.inputHandler.readPassword();
        }
        catch (IOException e) {
            throw new PrompterException("Failed to read password", (Throwable)e);
        }
    }

    public void showMessage(String message) throws PrompterException {
        try {
            this.outputHandler.write(message);
        }
        catch (IOException e) {
            throw new PrompterException("Failed to show message", (Throwable)e);
        }
    }

    private String readLine() throws PrompterException {
        try {
            return this.inputHandler.readLine();
        }
        catch (IOException e) {
            throw new PrompterException("Failed to read line", (Throwable)e);
        }
    }

    private void writePrompt(String message) throws PrompterException {
        this.showMessage(message + ": ");
    }
}

