/*
 * Decompiled with CFR 0.152.
 */
package net.unit8.waitt.mojo.component;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import net.unit8.waitt.api.EmbeddedServer;
import net.unit8.waitt.api.configuration.Server;
import net.unit8.waitt.mojo.component.ArtifactResolver;
import net.unit8.waitt.mojo.component.ServerProvider;
import net.unit8.waitt.mojo.configuration.ServerSpec;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;

public class DefaultServerProvider
implements ServerProvider {
    private static final Logger LOG = Logger.getLogger(DefaultServerProvider.class.getName());
    @Requirement
    private Prompter prompter;
    @Component
    protected ArtifactResolver artifactResolver;
    @Component
    protected RepositorySystem repositorySystem;

    @Override
    public ServerSpec getServer(Server server, ClassRealm parentRealm) {
        Artifact artifact = this.repositorySystem.createArtifact(server.getGroupId(), server.getArtifactId(), server.getVersion(), "jar");
        ClassRealm serverRealm = this.artifactResolver.resolve(artifact, parentRealm);
        ServiceLoader<EmbeddedServer> serviceLoaders = ServiceLoader.load(EmbeddedServer.class, (ClassLoader)serverRealm);
        Iterator<EmbeddedServer> iter = serviceLoaders.iterator();
        if (!iter.hasNext()) {
            throw new IllegalArgumentException("Embedded server is not found.");
        }
        return new ServerSpec(iter.next(), serverRealm);
    }

    @Override
    public ServerSpec selectServer(List<Server> servers, ClassRealm parentRealm, boolean interactive) throws MojoFailureException {
        if (servers == null || servers.isEmpty()) {
            throw new MojoFailureException(servers, "No settings for server.", "server not found");
        }
        ArrayList<ServerSpec> serverSpecs = new ArrayList<ServerSpec>();
        for (Server server : servers) {
            ServerSpec serverSpec = this.getServer(server, parentRealm);
            serverSpecs.add(serverSpec);
        }
        if (interactive && serverSpecs.size() > 1) {
            try {
                this.prompter.showMessage("Detect multiple servers...\n");
                ArrayList<String> possibleValues = new ArrayList<String>();
                for (int i = 0; i < serverSpecs.size(); ++i) {
                    possibleValues.add(Integer.toString(i));
                    this.prompter.showMessage("  " + i + ". " + ((ServerSpec)serverSpecs.get(i)).getEmbeddedServer().getName() + "\n");
                }
                String res = this.prompter.prompt("What number will you use? (default: 0)", possibleValues, "0");
                int num = Integer.parseInt(res);
                return (ServerSpec)serverSpecs.get(num);
            }
            catch (PrompterException e) {
                throw new MojoFailureException("Prompt error.", (Throwable)e);
            }
        }
        return (ServerSpec)serverSpecs.get(0);
    }
}

