/*
 * Decompiled with CFR 0.152.
 */
package net.unit8.waitt.mojo.log;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class WaittLogFilter
implements Filter {
    private final List<LoggerMatcher> matchers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WaittLogFilter() {
        Properties props = new Properties();
        InputStream in = null;
        try {
            in = this.getClass().getClassLoader().getResourceAsStream("waitt-loglevel.properties");
            if (in != null) {
                props.load(in);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        this.matchers = new ArrayList<LoggerMatcher>();
        for (String key : props.stringPropertyNames()) {
            String level = props.getProperty(key);
            this.matchers.add(new LoggerMatcher(key, level));
        }
        Collections.sort(this.matchers, new Comparator<LoggerMatcher>(){

            @Override
            public int compare(LoggerMatcher o1, LoggerMatcher o2) {
                return o2.getDepth() - o1.getDepth();
            }
        });
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        for (LoggerMatcher lm : this.matchers) {
            if (!lm.match(record)) continue;
            return false;
        }
        return true;
    }

    private static class LoggerMatcher {
        private String loggerPrefix;
        private Level level;
        private int depth;

        LoggerMatcher(String loggerPrefix, String levelName) {
            this.loggerPrefix = loggerPrefix;
            this.level = Level.parse(levelName);
            this.depth = 0;
            for (int i = 0; i < loggerPrefix.length(); ++i) {
                if (loggerPrefix.charAt(i) != '.') continue;
                ++this.depth;
            }
        }

        boolean match(LogRecord rec) {
            String loggerName = rec.getLoggerName();
            return loggerName != null && loggerName.startsWith(this.loggerPrefix) && rec.getLevel().intValue() <= this.level.intValue();
        }

        int getDepth() {
            return this.depth;
        }
    }
}

