/*
 * Decompiled with CFR 0.152.
 */
package net.unit8.waitt.mojo;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.unit8.waitt.api.ConfigurableFeature;
import net.unit8.waitt.api.EmbeddedServer;
import net.unit8.waitt.api.LogListener;
import net.unit8.waitt.api.ServerMonitor;
import net.unit8.waitt.api.WebappDecorator;
import net.unit8.waitt.api.configuration.Feature;
import net.unit8.waitt.api.configuration.Server;
import net.unit8.waitt.api.configuration.WebappConfiguration;
import net.unit8.waitt.mojo.PackageScanner;
import net.unit8.waitt.mojo.component.ArtifactResolver;
import net.unit8.waitt.mojo.component.ServerProvider;
import net.unit8.waitt.mojo.configuration.ExtraWebapp;
import net.unit8.waitt.mojo.configuration.ServerSpec;
import net.unit8.waitt.mojo.log.WaittLogHandler;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.util.DirectoryScanner;
import org.fusesource.jansi.AnsiConsole;

public abstract class AbstractRunMojo
extends AbstractMojo {
    private static final String[] WELLKNOWN_DOCROOT = new String[]{"src/main/webapp", "WebContent"};
    @Parameter
    private int port;
    @Parameter(defaultValue="8080")
    private int startPort;
    @Parameter(defaultValue="9000")
    private int endPort;
    @Parameter(defaultValue="")
    private String contextPath;
    @Parameter(defaultValue="")
    private String path;
    @Parameter
    private List<Server> servers;
    @Parameter
    private List<Feature> features;
    @Parameter
    protected File docBase;
    @Component
    protected ProjectBuilder projectBuilder;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    protected MavenSession session;
    @Component
    protected RepositorySystem repositorySystem;
    @Component
    protected ArtifactResolver artifactResolver;
    @Component
    protected ServerProvider serverProvider;
    private final List<ServerMonitor> serverMonitors = new ArrayList<ServerMonitor>();
    private final List<LogListener> logListeners = new ArrayList<LogListener>();
    private final List<ExtraWebapp> extraWebapps = new ArrayList<ExtraWebapp>();
    private final List<WebappDecorator> webappDecorators = new ArrayList<WebappDecorator>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        AnsiConsole.systemInstall();
        this.artifactResolver.setProject(this.project);
        this.artifactResolver.setSession(this.session);
        this.initLogger();
        if (this.docBase == null) {
            this.docBase = this.scanDocBase(new File("."));
        }
        WebappConfiguration webappConfig = new WebappConfiguration();
        webappConfig.setApplicationName(this.project.getName());
        webappConfig.setBaseDirectory(this.docBase);
        webappConfig.setPackages(PackageScanner.scan(new File(this.project.getBuild().getSourceDirectory())));
        webappConfig.setSourceDirectory(new File(this.project.getBuild().getSourceDirectory()));
        ClassRealm waittRealm = (ClassRealm)Thread.currentThread().getContextClassLoader();
        ServerSpec serverSpec = this.serverProvider.selectServer(this.servers, waittRealm, this.session.getSettings().getInteractiveMode());
        EmbeddedServer embeddedServer = serverSpec.getEmbeddedServer();
        if (this.port == 0) {
            this.scanPort();
        }
        embeddedServer.setPort(this.port);
        if (this.contextPath == null || this.contextPath.equals("/")) {
            this.contextPath = "";
        }
        embeddedServer.setBaseDir(".");
        this.loadFeature(waittRealm, webappConfig);
        try {
            embeddedServer.start();
            ClassRealm webappRealm = serverSpec.getClassRealm().createChildRealm("Application");
            Set<URL> classpathUrls = this.resolveClasspaths();
            for (URL url : classpathUrls) {
                webappRealm.addURL(url);
            }
            for (ServerMonitor serverMonitor : this.serverMonitors) {
                serverMonitor.init(embeddedServer);
            }
            embeddedServer.setWebappDecorators(this.webappDecorators);
            embeddedServer.setMainContext(this.contextPath, this.docBase.getAbsolutePath(), (ClassLoader)webappRealm);
            for (ExtraWebapp extraWebapp : this.extraWebapps) {
                extraWebapp.getRealm().setParentRealm(serverSpec.getClassRealm());
                embeddedServer.addContext("/_" + extraWebapp.getName(), extraWebapp.getWarPath(), (ClassLoader)extraWebapp.getRealm());
            }
            for (ServerMonitor serverMonitor : this.serverMonitors) {
                serverMonitor.start(embeddedServer);
            }
            this.path = this.path == null ? "" : this.path;
            this.afterStart();
            embeddedServer.await();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Fail to start server", e);
        }
        finally {
            embeddedServer.stop();
        }
    }

    protected abstract void afterStart() throws IOException;

    private void readArtifacts(String subDirectory, List<Artifact> artifacts, List<File> classpathFiles) throws MojoExecutionException {
        File modulePom = subDirectory == null || subDirectory.isEmpty() ? new File("pom.xml") : new File(subDirectory, "pom.xml");
        try {
            ProjectBuildingRequest request = this.session.getProjectBuildingRequest().setProcessPlugins(false).setResolveDependencies(true);
            ProjectBuildingResult result = this.projectBuilder.build(modulePom, request);
            MavenProject subProject = result.getProject();
            if ("war".equals(subProject.getPackaging())) {
                this.docBase = subDirectory == null || subDirectory.isEmpty() ? this.scanDocBase(new File(".")) : this.scanDocBase(new File(subDirectory));
            }
            for (Artifact dependency : subProject.getArtifacts()) {
                String scope = dependency.getScope();
                if (!"compile".equals(scope) && !"runtime".equals(scope) && !"system".equals(scope)) continue;
                artifacts.add(dependency);
            }
            classpathFiles.add(new File(subProject.getBuild().getOutputDirectory()));
        }
        catch (Exception e) {
            throw new MojoExecutionException("module(" + subDirectory + ") build failure", e);
        }
    }

    private void loadFeature(ClassRealm waittRealm, WebappConfiguration config) {
        if (this.features == null) {
            return;
        }
        for (Feature feature : this.features) {
            String type = feature.getType();
            if (type == null) {
                type = "jar";
            }
            Artifact artifact = this.repositorySystem.createArtifact(feature.getGroupId(), feature.getArtifactId(), feature.getVersion(), type);
            ClassRealm realm = this.artifactResolver.resolve(artifact, waittRealm);
            config.getFeatures().add(feature);
            if ("war".equals(artifact.getType())) {
                String name = artifact.getArtifactId();
                if (name.startsWith("waitt-")) {
                    name = name.substring("waitt-".length());
                }
                this.extraWebapps.add(new ExtraWebapp(name, artifact.getFile().getAbsolutePath(), realm));
                continue;
            }
            ServiceLoader<ServerMonitor> serverMonitorLoader = ServiceLoader.load(ServerMonitor.class, (ClassLoader)realm);
            for (ServerMonitor serverMonitor : serverMonitorLoader) {
                if (serverMonitor instanceof ConfigurableFeature) {
                    ((ConfigurableFeature)serverMonitor).config(config);
                }
                this.serverMonitors.add(serverMonitor);
            }
            ServiceLoader<LogListener> logListenerLoader = ServiceLoader.load(LogListener.class, (ClassLoader)realm);
            for (LogListener logListener : logListenerLoader) {
                if (logListener instanceof ConfigurableFeature) {
                    ((ConfigurableFeature)logListener).config(config);
                }
                this.logListeners.add(logListener);
            }
            ServiceLoader<WebappDecorator> serviceLoader = ServiceLoader.load(WebappDecorator.class, (ClassLoader)realm);
            for (WebappDecorator webappDecorator : serviceLoader) {
                if (webappDecorator instanceof ConfigurableFeature) {
                    ((ConfigurableFeature)webappDecorator).config(config);
                }
                this.webappDecorators.add(webappDecorator);
            }
        }
    }

    private void initLogger() {
        Logger logger = Logger.getLogger("");
        logger.setLevel(Level.ALL);
        for (Handler handler : logger.getHandlers()) {
            logger.removeHandler(handler);
        }
        logger.addHandler(new WaittLogHandler(this.getLog()));
        logger.addHandler(new Handler(){

            @Override
            public void publish(LogRecord record) {
                if (record.getLoggerName() != null && record.getLoggerName().startsWith("sun.awt.")) {
                    return;
                }
                Level lv = record.getLevel();
                for (LogListener logListener : AbstractRunMojo.this.logListeners) {
                    if (Arrays.asList(Level.ALL, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST).contains(lv)) {
                        logListener.debug((CharSequence)record.getMessage(), record.getThrown());
                        continue;
                    }
                    if (lv.equals(Level.INFO)) {
                        logListener.info((CharSequence)record.getMessage(), record.getThrown());
                        continue;
                    }
                    if (lv.equals(Level.WARNING)) {
                        logListener.warn((CharSequence)record.getMessage(), record.getThrown());
                        continue;
                    }
                    if (!lv.equals(Level.SEVERE)) continue;
                    logListener.error((CharSequence)record.getMessage(), record.getThrown());
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        });
    }

    private Set<URL> resolveClasspaths() throws MojoExecutionException {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        ArrayList<File> classpathFiles = new ArrayList<File>();
        if (this.project.getModel().getModules().isEmpty()) {
            this.readArtifacts("", artifacts, classpathFiles);
        } else {
            for (String module : this.project.getModel().getModules()) {
                this.readArtifacts(module, artifacts, classpathFiles);
            }
        }
        HashSet<URL> classpathUrls = new HashSet<URL>();
        HashSet<String> uniqueArtifacts = new HashSet<String>();
        try {
            for (File classpathFile : classpathFiles) {
                URL url = classpathFile.toURI().toURL();
                classpathUrls.add(url);
            }
            for (URL url : ((URLClassLoader)Thread.currentThread().getContextClassLoader()).getURLs()) {
                if (!url.toString().contains("/org/ow2/asm/") && !url.toString().contains("/waitt-maven-plugin/") && !url.toString().contains("/net/sourceforge/cobertura/")) continue;
                classpathUrls.add(url);
            }
            for (Artifact artifact : artifacts) {
                String versionlessKey;
                if ("provided".equals(artifact.getScope()) || uniqueArtifacts.contains(versionlessKey = ArtifactUtils.versionlessKey((Artifact)artifact))) continue;
                classpathUrls.add(artifact.getFile().toURI().toURL());
                uniqueArtifacts.add(versionlessKey);
            }
            return classpathUrls;
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Error during setting up classpath", (Exception)e);
        }
    }

    protected File scanDocBase(File baseDir) throws MojoExecutionException {
        for (String dirStr : WELLKNOWN_DOCROOT) {
            File docBase = new File(baseDir, dirStr);
            if (!docBase.isDirectory()) continue;
            return docBase;
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(baseDir);
        scanner.setIncludes(new String[]{"**/web.xml"});
        scanner.addDefaultExcludes();
        scanner.scan();
        for (String path : scanner.getIncludedFiles()) {
            File webxml = new File(baseDir, path);
            if (!"WEB-INF".equals(webxml.getParentFile().getName())) continue;
            this.getLog().info((CharSequence)("Found webapp root = " + webxml));
            return webxml.getParentFile().getParentFile();
        }
        File dummy = new File(baseDir, "target/dummy_webapp");
        if (!dummy.exists() && !dummy.mkdirs()) {
            throw new MojoExecutionException("Can't create webapp directory");
        }
        return dummy;
    }

    protected void scanPort() {
        for (int p = this.startPort; p <= this.endPort; ++p) {
            try {
                Socket sock = new Socket("localhost", p);
                sock.close();
                continue;
            }
            catch (IOException e) {
                this.port = p;
                return;
            }
        }
        throw new RuntimeException("Can't find available port from " + this.startPort + " to " + this.endPort);
    }

    public int getPort() {
        return this.port;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getPath() {
        return this.path;
    }
}

