/*
 * Decompiled with CFR 0.152.
 */
package net.unit8.waitt.mojo.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.unit8.waitt.mojo.log.TargetLengthBasedClassNameAbbreviator;
import org.codehaus.plexus.util.StringUtils;
import org.fusesource.jansi.Ansi;

public class WaittFormatter
extends Formatter {
    final TargetLengthBasedClassNameAbbreviator abbreviator = new TargetLengthBasedClassNameAbbreviator(35);

    @Override
    public String format(LogRecord record) {
        StringBuilder sb = new StringBuilder(256);
        sb.append(this.formatDate(record.getMillis())).append(" ").append(this.formatLevel(record.getLevel())).append(" ").append(this.formatLoggerName(record.getLoggerName())).append(": ").append(record.getMessage()).append('\n');
        if (record.getThrown() != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println();
            record.getThrown().printStackTrace(pw);
            pw.close();
            sb.append(sw.toString());
        }
        return sb.toString();
    }

    protected String formatLoggerName(String loggerName) {
        return Ansi.ansi().fg(Ansi.Color.GREEN).a(StringUtils.leftPad((String)this.abbreviator.abbreviate(loggerName), (int)35, (String)" ")).reset().toString();
    }

    protected String formatLevel(Level level) {
        if (level == Level.SEVERE) {
            return Ansi.ansi().a('[').fgBright(Ansi.Color.RED).a("ERROR").reset().a(']').toString();
        }
        if (level == Level.WARNING) {
            return Ansi.ansi().a('[').fgBright(Ansi.Color.YELLOW).a("WARN ").reset().a(']').toString();
        }
        if (level == Level.INFO) {
            return Ansi.ansi().a('[').fgBright(Ansi.Color.CYAN).a("INFO ").reset().a(']').toString();
        }
        return Ansi.ansi().a('[').fgBright(Ansi.Color.WHITE).a("DEBUG").reset().a(']').toString();
    }

    protected String formatDate(long millis) {
        StringBuilder sb = new StringBuilder(25);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(millis);
        return sb.append(cal.get(1)).append("-").append(StringUtils.leftPad((String)Integer.toString(cal.get(2) + 1), (int)2, (String)"0")).append("-").append(StringUtils.leftPad((String)Integer.toString(cal.get(5)), (int)2, (String)"0")).append(" ").append(StringUtils.leftPad((String)Integer.toString(cal.get(11)), (int)2, (String)"0")).append(":").append(StringUtils.leftPad((String)Integer.toString(cal.get(12)), (int)2, (String)"0")).append(":").append(StringUtils.leftPad((String)Integer.toString(cal.get(13)), (int)2, (String)"0")).append(".").append(StringUtils.leftPad((String)Integer.toString(cal.get(14)), (int)3, (String)"0")).toString();
    }
}

