/*
 * Decompiled with CFR 0.152.
 */
package net.unit8.waitt.mojo;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.unit8.waitt.api.configuration.Server;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.shade.DefaultShader;
import org.apache.maven.plugins.shade.ShadeRequest;
import org.apache.maven.plugins.shade.resource.ManifestResourceTransformer;
import org.apache.maven.plugins.shade.resource.ServicesResourceTransformer;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;

@Mojo(name="jar", requiresDependencyResolution=ResolutionScope.RUNTIME)
public class JarMojo
extends AbstractMojo {
    private static final String[] WELLKNOWN_DOCROOT = new String[]{"src/main/webapp", "WebContent"};
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Component
    protected RepositorySystem repositorySystem;
    @Parameter
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.finalName}", readonly=true)
    private String finalName;
    @Parameter
    private List<Server> servers;

    protected void createArchive(File jarFile) throws MojoExecutionException {
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(jarFile);
        archiver.getArchiver().addDirectory(new File(this.project.getBuild().getOutputDirectory()));
        try {
            archiver.createArchive(this.session, this.project, this.archive);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error assembling JAR", e);
        }
    }

    protected File getJarFile(File basedir, String resultFinalName) {
        if (basedir == null) {
            throw new IllegalArgumentException("basedir is not allowed to be null");
        }
        if (resultFinalName == null) {
            throw new IllegalArgumentException("finalName is not allowed to be null");
        }
        return new File(basedir, resultFinalName + ".jar");
    }

    protected Set<File> getDependencies() {
        HashSet<File> artifacts = new HashSet<File>();
        this.getLog().info((CharSequence)this.project.getArtifacts().toString());
        for (Artifact artifact : this.project.getArtifacts()) {
            artifacts.add(artifact.getFile());
        }
        return artifacts;
    }

    protected ManifestResourceTransformer createManifestTransformer(String mainClass) throws MojoExecutionException {
        try {
            ManifestResourceTransformer transformer = new ManifestResourceTransformer();
            Field mainClassField = ManifestResourceTransformer.class.getDeclaredField("mainClass");
            mainClassField.setAccessible(true);
            mainClassField.set(transformer, mainClass);
            return transformer;
        }
        catch (Exception e) {
            throw new MojoExecutionException("", e);
        }
    }

    private void resolveArtifact(String groupId, String artifactId, String version, Set<File> jars) {
        Artifact artifact = this.repositorySystem.createArtifact(groupId, artifactId, version, "jar");
        ArtifactResolutionRequest artifactRequest = new ArtifactResolutionRequest().setRemoteRepositories(this.project.getRemoteArtifactRepositories()).setLocalRepository(this.session.getLocalRepository()).setResolveRoot(true).setResolveTransitively(true).setArtifact(artifact);
        ArtifactResolutionResult artifactResult = this.repositorySystem.resolve(artifactRequest);
        for (Artifact resolvedArtifact : artifactResult.getArtifacts()) {
            if ("provided".equals(resolvedArtifact.getScope()) || "test".equals(resolvedArtifact.getScope())) continue;
            jars.add(resolvedArtifact.getFile());
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.servers.isEmpty()) {
            throw new MojoFailureException("Server is not found.");
        }
        DefaultShader shader = new DefaultShader();
        shader.enableLogging((Logger)new ConsoleLogger(0, "shader"));
        ShadeRequest request = new ShadeRequest();
        File jarFile = this.getJarFile(this.outputDirectory, this.finalName);
        this.createArchive(jarFile);
        request.setUberJar(new File(this.outputDirectory, this.project.getBuild().getFinalName() + "-standalone.jar"));
        Set<File> jars = this.getDependencies();
        Server server = this.servers.get(0);
        this.resolveArtifact(server.getGroupId(), server.getArtifactId(), server.getVersion(), jars);
        this.resolveArtifact("net.unit8.waitt", "waitt-embed-runner", "1.2.0-SNAPSHOT", jars);
        jars.add(new File(this.outputDirectory, this.project.getBuild().getFinalName() + ".jar"));
        request.setJars(jars);
        request.setFilters(Collections.emptyList());
        request.setRelocators(Collections.emptyList());
        ArrayList<Object> transformers = new ArrayList<Object>();
        transformers.add(this.createManifestTransformer("net.unit8.waitt.embed.Runner"));
        transformers.add(new ServicesResourceTransformer());
        request.setResourceTransformers(transformers);
        try {
            shader.shade(request);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("", (Exception)ex);
        }
    }
}

