/*
 * Decompiled with CFR 0.152.
 */
package net.unit8.waitt.mojo.component;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.unit8.waitt.mojo.component.ArtifactResolver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.classworlds.realm.ClassRealm;

public class DefaultArtifactResolver
implements ArtifactResolver {
    private static final Logger LOG = Logger.getLogger(DefaultArtifactResolver.class.getName());
    @Component
    protected RepositorySystem repositorySystem;
    protected MavenProject project;
    protected MavenSession session;

    @Override
    public ClassRealm resolve(Artifact artifact, ClassRealm parentRealm) {
        ClassRealm realm;
        ArtifactResolutionRequest artifactRequest = new ArtifactResolutionRequest().setRemoteRepositories(this.project.getRemoteArtifactRepositories()).setLocalRepository(this.session.getLocalRepository()).setResolveRoot(true).setResolveTransitively(true).setArtifact(artifact);
        ArtifactResolutionResult artifactResult = this.repositorySystem.resolve(artifactRequest);
        if (artifactResult.hasExceptions()) {
            for (Object e : artifactResult.getExceptions()) {
                LOG.log(Level.SEVERE, "resolve error.", (Throwable)e);
            }
        }
        try {
            realm = parentRealm.createChildRealm(artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion());
            for (Artifact resolvedArtifact : artifactResult.getArtifacts()) {
                if ("provided".equals(resolvedArtifact.getScope()) || "test".equals(resolvedArtifact.getScope())) continue;
                realm.addURL(resolvedArtifact.getFile().toURI().toURL());
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return realm;
    }

    @Override
    public void setProject(MavenProject project) {
        this.project = project;
    }

    @Override
    public void setSession(MavenSession session) {
        this.session = session;
    }
}

