/*
 * Decompiled with CFR 0.152.
 */
package net.unit8.waitt.feature.coverage;

import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import net.sourceforge.cobertura.coveragedata.CoverageDataFileHandler;
import net.sourceforge.cobertura.coveragedata.ProjectData;
import net.sourceforge.cobertura.coveragedata.TouchCollector;
import net.sourceforge.cobertura.reporting.ComplexityCalculator;
import net.sourceforge.cobertura.reporting.html.HTMLReport;
import net.sourceforge.cobertura.util.FileFinder;
import net.unit8.waitt.feature.coverage.CoberturaClassLoader;
import net.unit8.waitt.feature.coverage.CoverageMonitorConfiguration;

public class ReportGenerator
implements Runnable {
    private static final Logger LOG = Logger.getLogger(ReportGenerator.class.getName());
    private final ComplexityCalculator complexity;
    private final FileFinder finder;
    private final ClassLoader classLoader;
    private final File reportDirectory;
    private final long reportInterval;

    public ReportGenerator(ClassLoader classLoader, CoverageMonitorConfiguration config) {
        this.classLoader = classLoader;
        this.finder = new FileFinder();
        this.finder.addSourceDirectory(config.getSourceDirectory().getAbsolutePath());
        this.complexity = new ComplexityCalculator(this.finder);
        this.reportDirectory = config.getCoverageReportDirectory();
        this.reportInterval = config.getReportIntervalSeconds();
    }

    @Override
    public void run() {
        while (true) {
            if (!(this.classLoader instanceof CoberturaClassLoader)) break;
            ProjectData data = ((CoberturaClassLoader)this.classLoader).getInstrumenter().getProjectData();
            TouchCollector.applyTouchesOnProjectData((ProjectData)data);
            CoverageDataFileHandler.saveCoverageData((ProjectData)data, (File)CoverageDataFileHandler.getDefaultDataFile());
            try {
                new HTMLReport(data, this.reportDirectory, this.finder, this.complexity, "UTF-8");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                TimeUnit.SECONDS.sleep(this.reportInterval);
            }
            catch (InterruptedException interruptedException) {}
        }
        LOG.warning("CoverageMonitor wasn't loaded from CoberturaClassLoader.");
    }
}

