/*
 * Decompiled with CFR 0.152.
 */
package net.unit8.waitt.feature.coverage;

import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import net.sourceforge.cobertura.coveragedata.CoverageDataFileHandler;
import net.unit8.waitt.api.ClassLoaderFactory;
import net.unit8.waitt.api.ConfigurableFeature;
import net.unit8.waitt.api.EmbeddedServer;
import net.unit8.waitt.api.ServerMonitor;
import net.unit8.waitt.api.configuration.WebappConfiguration;
import net.unit8.waitt.feature.coverage.CoberturaClassLoader;
import net.unit8.waitt.feature.coverage.CoverageMonitorConfiguration;
import net.unit8.waitt.feature.coverage.ReportGenerator;
import org.codehaus.plexus.classworlds.realm.ClassRealm;

public class CoverageMonitor
implements ServerMonitor,
ConfigurableFeature {
    private static final Logger LOG = Logger.getLogger(CoverageMonitor.class.getName());
    private final CoverageMonitorConfiguration config;
    ExecutorService executorService;

    public CoverageMonitor() {
        Logger logger = Logger.getLogger(CoverageDataFileHandler.class.getName());
        logger.setUseParentHandlers(false);
        this.config = new CoverageMonitorConfiguration();
    }

    public void config(WebappConfiguration webappConfig) {
        this.config.setSourceDirectory(webappConfig.getSourceDirectory());
        this.config.setTargetPackages(webappConfig.getPackages());
    }

    public void init(EmbeddedServer server) {
        final ClassRealm coverageRealm = (ClassRealm)this.getClass().getClassLoader();
        server.setClassLoaderFactory(new ClassLoaderFactory(){

            public ClassLoader create(ClassLoader parent) {
                coverageRealm.setParentClassLoader(parent);
                CoberturaClassLoader ccl = CoberturaClassLoader.create((ClassLoader)coverageRealm);
                ccl.setTargetPackages(CoverageMonitor.this.config.getTargetPackages());
                return ccl;
            }
        });
    }

    public void start(EmbeddedServer server) {
        File reportDirectory = new File("target/coverage");
        if (!reportDirectory.exists()) {
            reportDirectory.mkdirs();
        }
        this.config.setCoverageReportDirectory(reportDirectory);
        server.addContext("/_coverage", reportDirectory.getAbsolutePath(), this.getClass().getClassLoader());
        this.executorService = Executors.newCachedThreadPool();
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        CoberturaClassLoader loader = CoberturaClassLoader.getInstance();
                        LOG.info("Start reporting Coverage report");
                        CoverageMonitor.this.executorService.execute(new ReportGenerator(loader, CoverageMonitor.this.config));
                    }
                    catch (IllegalStateException e) {
                        try {
                            TimeUnit.SECONDS.sleep(5L);
                        }
                        catch (InterruptedException ex) {
                            break;
                        }
                    }
                }
            }
        });
    }

    public void stop() {
        this.executorService.shutdown();
    }
}

