/*
 * Decompiled with CFR 0.152.
 */
package net.unit8.waitt.feature.coverage;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.sourceforge.cobertura.util.IOUtil;
import net.unit8.waitt.feature.coverage.CoberturaInstrumenterWrapper;
import net.unit8.waitt.feature.coverage.Instrumenter;

public class CoberturaClassLoader
extends ClassLoader {
    private static final Logger logger = Logger.getLogger(CoberturaClassLoader.class.getName());
    private static CoberturaClassLoader instance;
    private Set<String> targetPackages;
    private final Collection<Pattern> ignoreRegexes = new Vector<Pattern>();
    private final Set<String> ignoreMethodAnnotations = new HashSet<String>();
    private Instrumenter instrumenter = null;

    private CoberturaClassLoader(ClassLoader parent) {
        super(parent);
        this.initInstrumenter();
    }

    public static synchronized CoberturaClassLoader create(ClassLoader parent) {
        if (instance == null) {
            instance = new CoberturaClassLoader(parent);
        }
        return instance;
    }

    public static CoberturaClassLoader getInstance() {
        if (instance == null) {
            throw new IllegalStateException("CoberturaClassLoader hasn't been instantiated yet.");
        }
        return instance;
    }

    private void initInstrumenter() {
        this.instrumenter = new CoberturaInstrumenterWrapper();
        this.instrumenter.setIgnoreRegexes(this.ignoreRegexes);
        this.instrumenter.setIgnoreTrivial(false);
        this.instrumenter.setIgnoreMethodAnnotations(this.ignoreMethodAnnotations);
        this.instrumenter.setThreadsafeRigorous(false);
        this.instrumenter.setFailOnError(false);
    }

    public Class loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(className);
        if (clazz != null) {
            return clazz;
        }
        Boolean isTargetPackage = false;
        for (String pkgName : this.targetPackages) {
            isTargetPackage = isTargetPackage | className.startsWith(pkgName);
        }
        if (isTargetPackage.booleanValue()) {
            logger.fine("[loaded] " + className + " from CoberturaClassLoader");
            return this.defineClass(className, resolve);
        }
        return this.getParent().loadClass(className);
    }

    private Class defineClass(String className, boolean resolve) throws ClassNotFoundException {
        Class clazz = null;
        String path = className.replace('.', '/') + ".class";
        InputStream is = this.getParent().getResourceAsStream(path);
        byte[] instrumentationResult = null;
        try {
            instrumentationResult = this.instrumenter.instrumentClassByte(is);
            if (instrumentationResult == null) {
                Class<?> clazz2 = this.getParent().loadClass(className);
                return clazz2;
            }
        }
        catch (Throwable t) {
            throw new ClassNotFoundException(className + " from " + this.getParent(), t);
        }
        finally {
            IOUtil.closeInputStream((InputStream)is);
        }
        if (is != null) {
            clazz = this.defineClass(className, instrumentationResult);
            if (resolve) {
                this.resolveClass(clazz);
            }
        }
        return clazz;
    }

    Class defineClass(String className, byte[] bytes) {
        return this.defineClass(className, bytes, 0, bytes.length);
    }

    public Instrumenter getInstrumenter() {
        return this.instrumenter;
    }

    public void setTargetPackages(Set<String> targetPackages) {
        this.targetPackages = targetPackages;
    }
}

