/*
 * Decompiled with CFR 0.152.
 */
package net.unit8.waitt;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import net.unit8.waitt.CoverageMonitorConfiguration;
import net.unit8.waitt.PackageScanner;
import net.unit8.waitt.ParentLastClassLoader;
import net.unit8.waitt.TargetPackages;
import net.unit8.waitt.WaittServlet;
import net.unit8.waitt.Webapp;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Server;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.AprLifecycleListener;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.startup.Tomcat;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.repository.RepositorySystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="run")
public class RunMojo
extends AbstractMojo {
    @Parameter
    private int port;
    @Parameter(defaultValue="8080")
    private int startPort;
    @Parameter(defaultValue="9000")
    private int endPort;
    @Parameter(defaultValue="")
    private String contextPath;
    @Parameter(defaultValue="")
    private String path;
    @Parameter(defaultValue="true")
    private boolean delegate;
    @Parameter
    private List<Webapp> webapps;
    @Component
    protected MavenProject project;
    @Component
    protected ProjectBuilder projectBuilder;
    @Component
    protected RepositorySystem repositorySystem;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    protected MavenSession session;
    @Parameter(defaultValue="target/coverage")
    protected File coverageReportDirectory;
    protected String appBase;
    private final ExecutorService executorService = Executors.newCachedThreadPool();

    private void readArtifacts(String subDirectory, List<Artifact> artifacts, List<File> classpathFiles) throws MojoExecutionException {
        File modulePom = subDirectory == null || subDirectory.isEmpty() ? new File("pom.xml") : new File(subDirectory, "pom.xml");
        try {
            ProjectBuildingRequest request = this.session.getProjectBuildingRequest().setProcessPlugins(false).setResolveDependencies(true);
            ProjectBuildingResult result = this.projectBuilder.build(modulePom, request);
            MavenProject subProject = result.getProject();
            if ("war".equals(subProject.getPackaging())) {
                this.appBase = subDirectory == null || subDirectory.isEmpty() ? new File("src/main/webapp").getAbsolutePath() : new File(subDirectory, "src/main/webapp").getAbsolutePath();
            }
            for (Artifact dependency : subProject.getArtifacts()) {
                String scope = dependency.getScope();
                if (!"compile".equals(scope) && !"runtime".equals(scope) && !"system".equals(scope)) continue;
                artifacts.add(dependency);
            }
            classpathFiles.add(new File(subProject.getBuild().getOutputDirectory()));
        }
        catch (Exception e) {
            throw new MojoExecutionException("module(" + subDirectory + ") build failure", e);
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.initLogger();
        List<URL> classpathUrls = this.resolveClasspaths();
        ParentLastClassLoader parentClassLoader = new ParentLastClassLoader(classpathUrls.toArray(new URL[classpathUrls.size()]), Thread.currentThread().getContextClassLoader());
        if (this.appBase == null) {
            this.appBase = new File("src/main/webapp").getAbsolutePath();
        }
        this.getLog().info((CharSequence)("App base: " + this.appBase));
        Tomcat tomcat = new Tomcat();
        ((StandardHost)tomcat.getHost()).setUnpackWARs(false);
        if (this.port == 0) {
            this.scanPort();
        }
        tomcat.setPort(this.port);
        if (this.contextPath == null || this.contextPath.equals("/")) {
            this.contextPath = "";
        }
        System.setProperty("catalina.home", ".");
        tomcat.setBaseDir(".");
        tomcat.getHost().setAppBase(this.appBase);
        StandardServer server = (StandardServer)tomcat.getServer();
        AprLifecycleListener listener = new AprLifecycleListener();
        server.addLifecycleListener((LifecycleListener)listener);
        tomcat.getConnector().setURIEncoding("UTF-8");
        tomcat.getConnector().setUseBodyEncodingForURI(true);
        try {
            Context context = tomcat.addWebapp(this.contextPath, this.appBase);
            WebappLoader webappLoader = new WebappLoader((ClassLoader)parentClassLoader);
            webappLoader.setLoaderClass("net.unit8.waitt.CoberturaClassLoader");
            webappLoader.setDelegate(this.delegate);
            context.setLoader((Loader)webappLoader);
            context.setSessionCookieDomain(null);
            this.initCoverageContext(tomcat);
            if (this.webapps != null) {
                for (Webapp webapp : this.webapps) {
                    this.initExtraWebapp(tomcat, webapp);
                }
            }
            WaittServlet waittServlet = new WaittServlet((Server)server, this.executorService);
            Context adminContext = tomcat.addContext("/waitt", "");
            adminContext.setParentClassLoader(Thread.currentThread().getContextClassLoader());
            Tomcat.addServlet((Context)adminContext, (String)"waittServlet", (Servlet)waittServlet);
            adminContext.addServletMapping("/*", "waittServlet");
            this.initCoverageMonitor(webappLoader);
            tomcat.start();
            this.path = this.path == null ? "" : this.path;
            Desktop.getDesktop().browse(URI.create("http://localhost:" + this.port + this.contextPath + this.path));
            server.addLifecycleListener(new LifecycleListener(){

                public void lifecycleEvent(LifecycleEvent event) {
                    if (event.getType().equals("before_stop")) {
                        RunMojo.this.executorService.shutdownNow();
                        RunMojo.this.getLog().info((CharSequence)"Stop monitoring threads.");
                    }
                }
            });
            server.await();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Tomcat start failure", e);
        }
    }

    private void initExtraWebapp(Tomcat tomcat, Webapp webapp) throws MalformedURLException, ServletException {
        Artifact artifact = this.repositorySystem.createArtifact(webapp.getGroupId(), webapp.getArtifactId(), webapp.getVersion(), "war");
        ArtifactResolutionRequest warArtifactRequest = new ArtifactResolutionRequest().setRemoteRepositories(this.project.getRemoteArtifactRepositories()).setArtifact(artifact);
        ArtifactResolutionResult warArtifactResult = this.repositorySystem.resolve(warArtifactRequest);
        if (warArtifactResult.hasExceptions()) {
            for (Exception e : warArtifactResult.getExceptions()) {
                this.getLog().error((CharSequence)"resolve error.", (Throwable)e);
            }
        }
        Dependency d = new Dependency();
        d.setGroupId(webapp.getGroupId());
        d.setArtifactId(webapp.getArtifactId());
        d.setVersion(webapp.getVersion());
        d.setType("jar");
        ArtifactResolutionRequest artifactRequest = new ArtifactResolutionRequest();
        artifactRequest.setArtifact(this.repositorySystem.createDependencyArtifact(d)).setResolveTransitively(true).setResolveRoot(false).setLocalRepository(this.session.getLocalRepository()).setRemoteRepositories(this.project.getRemoteArtifactRepositories());
        ArtifactResolutionResult artifactResult = this.repositorySystem.resolve(artifactRequest);
        ArrayList<URL> classpathUrls = new ArrayList<URL>();
        for (Artifact artifact2 : artifactResult.getArtifacts()) {
            if ("provided".equals(artifact.getScope())) continue;
            classpathUrls.add(artifact2.getFile().toURI().toURL());
        }
        if (webapp.getDependencies() != null) {
            for (Dependency dependency : webapp.getDependencies()) {
                ArtifactResolutionRequest depRequest = new ArtifactResolutionRequest();
                depRequest.setArtifact(this.repositorySystem.createDependencyArtifact(dependency)).setResolveRoot(true).setResolveTransitively(true).setLocalRepository(this.session.getLocalRepository()).setRemoteRepositories(this.project.getRemoteArtifactRepositories());
                ArtifactResolutionResult depResult = this.repositorySystem.resolve(depRequest);
                for (Artifact depArtifact : depResult.getArtifacts()) {
                    if ("provided".equals(artifact.getScope())) continue;
                    classpathUrls.add(depArtifact.getFile().toURI().toURL());
                }
            }
        }
        Context extContext = tomcat.addWebapp(webapp.getPath(), artifact.getFile().getAbsolutePath());
        extContext.addParameter("antiJARLocking", "false");
        extContext.addParameter("antiResourceLocking", "false");
        extContext.addParameter("unpackWARs", "false");
        extContext.setLoader((Loader)new WebappLoader((ClassLoader)new URLClassLoader(classpathUrls.toArray(new URL[classpathUrls.size()]), Thread.currentThread().getContextClassLoader())));
        for (Map.Entry<String, String> entry : webapp.getConfiguration().entrySet()) {
            System.setProperty(entry.getKey(), entry.getValue());
        }
    }

    private void initLogger() {
        Logger logger = Logger.getLogger("");
        logger.setLevel(Level.ALL);
        for (Handler handler : logger.getHandlers()) {
            logger.removeHandler(handler);
        }
        final Log mavenLogger = this.getLog();
        logger.addHandler(new Handler(){

            public void publish(LogRecord logRecord) {
                if (logRecord.getLoggerName().startsWith("sun.awt.")) {
                    return;
                }
                Level lv = logRecord.getLevel();
                if (Arrays.asList(Level.ALL, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST).contains(lv)) {
                    mavenLogger.debug((CharSequence)logRecord.getMessage());
                } else if (lv.equals(Level.INFO)) {
                    mavenLogger.info((CharSequence)logRecord.getMessage());
                } else if (lv.equals(Level.WARNING)) {
                    Throwable t = logRecord.getThrown();
                    if (t == null) {
                        mavenLogger.warn((CharSequence)logRecord.getMessage());
                    } else {
                        mavenLogger.warn((CharSequence)logRecord.getMessage(), t);
                    }
                } else if (lv.equals(Level.SEVERE)) {
                    Throwable t = logRecord.getThrown();
                    if (t == null) {
                        mavenLogger.error((CharSequence)logRecord.getMessage());
                    } else {
                        mavenLogger.error((CharSequence)logRecord.getMessage(), t);
                    }
                }
            }

            public void flush() {
            }

            public void close() throws SecurityException {
            }
        });
    }

    private List<URL> resolveClasspaths() throws MojoExecutionException {
        TargetPackages.getInstance().set(PackageScanner.scan(new File(this.project.getBuild().getSourceDirectory())));
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        ArrayList<File> classpathFiles = new ArrayList<File>();
        if (this.project.getModel().getModules().isEmpty()) {
            this.readArtifacts("", artifacts, classpathFiles);
        } else {
            for (String module : this.project.getModel().getModules()) {
                this.readArtifacts(module, artifacts, classpathFiles);
            }
        }
        ArrayList<URL> classpathUrls = new ArrayList<URL>();
        HashSet<String> uniqueArtifacts = new HashSet<String>();
        try {
            for (File classpathFile : classpathFiles) {
                URL url = classpathFile.toURI().toURL();
                classpathUrls.add(url);
            }
            for (URL url : ((URLClassLoader)Thread.currentThread().getContextClassLoader()).getURLs()) {
                if (!url.toString().contains("/org/ow2/asm/") && !url.toString().contains("/waitt-maven-plugin/") && !url.toString().contains("/net/sourceforge/cobertura/")) continue;
                classpathUrls.add(url);
            }
            for (Artifact artifact : artifacts) {
                String versionlessKey;
                if ("provided".equals(artifact.getScope()) || uniqueArtifacts.contains(versionlessKey = ArtifactUtils.versionlessKey((Artifact)artifact))) continue;
                classpathUrls.add(artifact.getFile().toURI().toURL());
                uniqueArtifacts.add(versionlessKey);
            }
            return classpathUrls;
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Error during setting up classpath", (Exception)e);
        }
    }

    private void initCoverageContext(Tomcat tomcat) {
        if (!this.coverageReportDirectory.exists()) assert (this.coverageReportDirectory.mkdirs());
        Context coverageContext = tomcat.addContext("/coverage", this.coverageReportDirectory.getAbsolutePath());
        coverageContext.setParentClassLoader(Thread.currentThread().getContextClassLoader());
        Wrapper defaultServlet = coverageContext.createWrapper();
        defaultServlet.setName("default");
        defaultServlet.setServletClass("org.apache.catalina.servlets.DefaultServlet");
        defaultServlet.addInitParameter("debug", "0");
        defaultServlet.addInitParameter("listings", "false");
        defaultServlet.setLoadOnStartup(1);
        coverageContext.addChild((Container)defaultServlet);
        coverageContext.addServletMapping("/", "default");
        coverageContext.addWelcomeFile("index.html");
    }

    private void initCoverageMonitor(final WebappLoader webappLoader) {
        final CoverageMonitorConfiguration config = new CoverageMonitorConfiguration();
        config.setCoverageReportDirectory(this.coverageReportDirectory);
        config.setSourceDirectory(new File(this.project.getBuild().getSourceDirectory()));
        this.executorService.execute(new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Lifted jumps to return sites
             */
            public void run() {
                while (true) {
                    ClassLoader cl;
                    if ((cl = webappLoader.getClassLoader()) != null) {
                        try {
                            Class<?> monitorClass = cl.loadClass("net.unit8.waitt.CoverageMonitor");
                            Constructor<?> constructor = monitorClass.getConstructor(WebappLoader.class, CoverageMonitorConfiguration.class);
                            RunMojo.this.executorService.execute((Runnable)constructor.newInstance(webappLoader, config));
                            return;
                        }
                        catch (Exception e) {
                            RunMojo.this.getLog().warn((Throwable)e);
                            return;
                        }
                    }
                    try {
                        Thread.sleep(5000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        assert (false);
                        continue;
                    }
                    break;
                }
            }
        });
    }

    protected void scanPort() {
        for (int p = this.startPort; p <= this.endPort; ++p) {
            try {
                Socket sock = new Socket("localhost", p);
                sock.close();
                continue;
            }
            catch (IOException e) {
                this.port = p;
                return;
            }
        }
        throw new RuntimeException("Can't find available port from " + this.startPort + " to " + this.endPort);
    }
}

