/*
 * Decompiled with CFR 0.152.
 */
package net.unit8.waitt;

import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParentLastClassLoader
extends URLClassLoader {
    private static final Logger logger = Logger.getLogger(ParentLastClassLoader.class.getName());
    static final Method findLoadedClassMethod;
    static final Method findBootstrapClassOrNullMethod;

    public ParentLastClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public ParentLastClassLoader(URL[] urls) {
        super(urls);
    }

    public ParentLastClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(urls, parent, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        ParentLastClassLoader parentLastClassLoader = this;
        synchronized (parentLastClassLoader) {
            Class loadedClass = this.findLoadedClass(name);
            if (loadedClass == null) {
                try {
                    loadedClass = (Class)findBootstrapClassOrNullMethod.invoke((Object)this.getParent(), name);
                    for (ClassLoader parent = this.getParent(); parent != null && loadedClass == null; parent = parent.getParent()) {
                        loadedClass = (Class)findLoadedClassMethod.invoke((Object)parent, name);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (loadedClass == null) {
                try {
                    if (name.equals("net.unit8.waitt.Instrumenter")) {
                        throw new ClassNotFoundException("");
                    }
                    loadedClass = this.findClass(name);
                    logger.fine("[loaded] " + name + " from ParentLastClassLoader");
                    if (resolve) {
                        this.resolveClass(loadedClass);
                    }
                }
                catch (ClassNotFoundException e) {
                }
                catch (IllegalAccessError e) {
                    loadedClass = this.getParent().loadClass(name);
                    logger.fine("[loaded] " + name + " from WebappClassLoader");
                }
                if (loadedClass == null) {
                    loadedClass = super.loadClass(name, resolve);
                    logger.fine("[loaded] " + name + " from WebappClassLoader");
                }
            }
            return loadedClass;
        }
    }

    static {
        try {
            findLoadedClassMethod = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
            findLoadedClassMethod.setAccessible(true);
            findBootstrapClassOrNullMethod = ClassLoader.class.getDeclaredMethod("findBootstrapClassOrNull", String.class);
            findBootstrapClassOrNullMethod.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

