/*
 * Decompiled with CFR 0.152.
 */
package net.unit8.waitt;

import java.io.File;
import java.io.FileFilter;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageScanner {
    public static Set<String> scan(File sourceDirectory) {
        HashSet<String> packages = new HashSet<String>();
        File[] directories = sourceDirectory.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f != null && f.isDirectory();
            }
        });
        if (directories != null) {
            for (File dir : directories) {
                PackageScanner.scanPackageInner(dir, null, packages);
            }
        }
        return packages;
    }

    private static void scanPackageInner(File dir, String pkg, Set<String> packages) {
        if (!dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        Boolean isAllDirectory = true;
        for (File f : files) {
            isAllDirectory = f != null && f.isDirectory();
        }
        if (isAllDirectory.booleanValue()) {
            for (File f : files) {
                String prefix = pkg == null ? "" : pkg + ".";
                PackageScanner.scanPackageInner(f, prefix + dir.getName(), packages);
            }
        } else {
            packages.add(pkg == null ? dir.getName() : pkg);
        }
    }
}

