/*
 * Decompiled with CFR 0.152.
 */
package net.unit8.waitt;

import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import net.sourceforge.cobertura.coveragedata.CoverageDataFileHandler;
import net.sourceforge.cobertura.coveragedata.ProjectData;
import net.sourceforge.cobertura.coveragedata.TouchCollector;
import net.sourceforge.cobertura.reporting.ComplexityCalculator;
import net.sourceforge.cobertura.reporting.html.HTMLReport;
import net.sourceforge.cobertura.util.FileFinder;
import net.unit8.waitt.CoberturaClassLoader;
import net.unit8.waitt.CoverageMonitorConfiguration;
import org.apache.catalina.loader.WebappLoader;

public class CoverageMonitor
implements Runnable {
    private static final Logger logger = Logger.getLogger(CoverageMonitor.class.getName());
    private final ComplexityCalculator complexity;
    private final FileFinder finder;
    private final WebappLoader webappLoader;
    private final CoverageMonitorConfiguration config;

    public CoverageMonitor(WebappLoader webappLoader, CoverageMonitorConfiguration config) {
        this.webappLoader = webappLoader;
        this.config = config;
        this.finder = new FileFinder();
        this.finder.addSourceDirectory(config.getSourceDirectory().getAbsolutePath());
        this.complexity = new ComplexityCalculator(this.finder);
        Logger logger = Logger.getLogger(CoverageDataFileHandler.class.getName());
        logger.setUseParentHandlers(false);
    }

    public void run() {
        while (true) {
            ClassLoader cl;
            if (!((cl = this.webappLoader.getClassLoader()) instanceof CoberturaClassLoader)) break;
            ProjectData data = ((CoberturaClassLoader)((Object)cl)).getInstrumenter().getProjectData();
            TouchCollector.applyTouchesOnProjectData((ProjectData)data);
            CoverageDataFileHandler.saveCoverageData((ProjectData)data, (File)CoverageDataFileHandler.getDefaultDataFile());
            try {
                new HTMLReport(data, this.config.getCoverageReportDirectory(), this.finder, this.complexity, "UTF-8");
            }
            catch (Exception ignore) {
                // empty catch block
            }
            try {
                TimeUnit.SECONDS.sleep(this.config.getReportIntervalSeconds());
            }
            catch (InterruptedException interruptedException) {}
        }
        logger.warning("CoverageMonitor wasn't loaded from CoberturaClassLoader.");
    }
}

