/*
 * Decompiled with CFR 0.152.
 */
package net.unit8.falchion.jetty9;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.ServerSocketChannel;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.annotation.Name;

public class ReusePortConnector
extends ServerConnector {
    public ReusePortConnector(@Name(value="server") Server server) {
        super(server);
    }

    public ReusePortConnector(@Name(value="server") Server server, ConnectionFactory ... factories) {
        super(server, factories);
    }

    public void open() throws IOException {
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        serverChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEPORT, (Object)true);
        InetSocketAddress bindAddress = this.getHost() == null ? new InetSocketAddress(this.getPort()) : new InetSocketAddress(this.getHost(), this.getPort());
        serverChannel.socket().setReuseAddress(this.getReuseAddress());
        serverChannel.socket().bind(bindAddress, this.getAcceptQueueSize());
        serverChannel.configureBlocking(true);
        this.addBean(serverChannel);
        try {
            Field acceptChannel = ServerConnector.class.getDeclaredField("_acceptChannel");
            acceptChannel.setAccessible(true);
            acceptChannel.set((Object)this, serverChannel);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }
}

