/*
 * Decompiled with CFR 0.152.
 */
package enkan.util;

import enkan.collection.Headers;
import enkan.collection.OptionMap;
import enkan.data.HttpResponse;
import enkan.exception.FalteringEnvironmentException;
import enkan.exception.MisconfigurationException;
import enkan.exception.UnreachableException;
import enkan.util.BeanBuilder;
import enkan.util.HttpDateFormat;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class HttpResponseUtils {
    public static HttpResponse redirect(String url, RedirectStatusCode code) {
        return (HttpResponse)BeanBuilder.builder((Object)HttpResponse.of("")).set(HttpResponse::setStatus, (Object)code.getStatusCode()).set(HttpResponse::setHeaders, (Object)Headers.of("Location", url)).build();
    }

    public static HttpResponse response(String body) {
        return (HttpResponse)BeanBuilder.builder((Object)HttpResponse.of(body)).set(HttpResponse::setStatus, (Object)200).build();
    }

    public static <T> T getHeader(HttpResponse response, String name) {
        return (T)response.getHeaders().get(name);
    }

    public static void header(HttpResponse response, String name, String value) {
        response.getHeaders().put(name, value);
    }

    public static <T> void charset(HttpResponse response, String charset) {
        String type = (String)HttpResponseUtils.getHeader(response, "Content-Type");
        if (type == null) {
            type = "text/plain";
        }
        String newType = type.replaceAll(";\\s*charset=[^;]*", "") + "; charset=" + charset;
        response.getHeaders().remove("Content-Type");
        HttpResponseUtils.header(response, "Content-Type", newType);
    }

    public static HttpResponse contentType(HttpResponse response, String type) {
        if (type != null) {
            response.getHeaders().remove("Content-Type");
            response.getHeaders().put("Content-Type", type);
        }
        return response;
    }

    public static HttpResponse contentLength(HttpResponse response, Long len) {
        if (len != null) {
            response.getHeaders().remove("Content-Length");
            response.getHeaders().put("Content-Length", len);
        }
        return response;
    }

    public static HttpResponse lastModified(HttpResponse response, Date lastModified) {
        if (lastModified != null) {
            response.getHeaders().remove("Last-Modified");
            response.getHeaders().put("Last-Modified", HttpDateFormat.RFC1123.format(lastModified));
        }
        return response;
    }

    private static String addEndingSlash(String path) {
        return path.endsWith("/") ? path : path + "/";
    }

    public static boolean isJarDirectory(JarURLConnection conn) throws IOException {
        String entryName;
        JarFile jarFile = conn.getJarFile();
        ZipEntry dirEntry = jarFile.getEntry(HttpResponseUtils.addEndingSlash(entryName = conn.getEntryName()));
        return dirEntry != null && dirEntry.isDirectory();
    }

    public static Long connectionContentLength(URLConnection conn) {
        long len = conn.getContentLengthLong();
        return len <= 0L ? null : Long.valueOf(len);
    }

    public static Date connectionLastModified(URLConnection conn) {
        long lastMod = conn.getLastModified();
        return lastMod > 0L ? new Date(lastMod) : null;
    }

    public static ContentData resourceData(URL url) {
        block8: {
            String protocol = url.getProtocol();
            if ("file".equals(protocol)) {
                try {
                    File file = new File(url.toURI());
                    if (!file.isDirectory()) {
                        return new FileContentData(file, (Long)file.length(), new Date(file.lastModified() / 1000L * 1000L));
                    }
                    break block8;
                }
                catch (URISyntaxException e) {
                    throw new UnreachableException((Throwable)e);
                }
            }
            if ("jar".equals(protocol)) {
                try {
                    JarURLConnection connection = (JarURLConnection)url.openConnection();
                    if (connection != null && !HttpResponseUtils.isJarDirectory(connection)) {
                        return new StreamContentData(connection.getInputStream(), HttpResponseUtils.connectionContentLength(connection), HttpResponseUtils.connectionLastModified(connection));
                    }
                }
                catch (IOException e) {
                    throw new FalteringEnvironmentException((Throwable)e);
                }
            }
        }
        return null;
    }

    public static HttpResponse urlResponse(URL url) {
        HttpResponse response;
        ContentData data = HttpResponseUtils.resourceData(url);
        if (data == null) {
            return null;
        }
        if (data instanceof FileContentData) {
            response = HttpResponse.of((File)((FileContentData)data).getContent());
        } else if (data instanceof StreamContentData) {
            response = HttpResponse.of((InputStream)((StreamContentData)data).getContent());
        } else {
            throw new MisconfigurationException("web.CLASSPATH", new Object[]{url.getProtocol(), url});
        }
        HttpResponseUtils.contentLength(response, data.getContentLength());
        HttpResponseUtils.lastModified(response, data.getLastModifiedDate());
        return response;
    }

    public static HttpResponse resourceResponse(String path, OptionMap options) {
        URL url;
        String root = options.getString("root");
        path = (root != null ? root : "") + "/" + path;
        path = path.replace("//", "/").replaceAll("^/", "");
        ClassLoader loader = (ClassLoader)options.get((Object)"loader");
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        return (url = loader.getResource(path)) != null ? HttpResponseUtils.urlResponse(url) : null;
    }

    public static boolean isEmptyBody(HttpResponse response) {
        Object body = response.getBody();
        return body == null || body instanceof String && ((String)body).isEmpty();
    }

    private static class StreamContentData
    extends ContentData<InputStream> {
        public StreamContentData(InputStream content, Long contentLength, Date lastModifiedDate) {
            super(content, contentLength, lastModifiedDate);
        }
    }

    private static class FileContentData
    extends ContentData<File> {
        public FileContentData(File content, Long contentLength, Date lastModifiedDate) {
            super(content, contentLength, lastModifiedDate);
        }
    }

    private static abstract class ContentData<T>
    implements Serializable {
        private T content;
        private Long contentLength;
        private Date lastModifiedDate;

        public ContentData(T content, Long contentLength, Date lastModifiedDate) {
            this.content = content;
            this.contentLength = contentLength;
            this.lastModifiedDate = lastModifiedDate;
        }

        public T getContent() {
            return this.content;
        }

        public void setContent(T content) {
            this.content = content;
        }

        public Long getContentLength() {
            return this.contentLength;
        }

        public void setContentLength(Long contentLength) {
            this.contentLength = contentLength;
        }

        public Date getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public void setLastModifiedDate(Date lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }
    }

    public static enum RedirectStatusCode {
        MOVED_PERMANENTLY(301),
        FOUND(302),
        SEE_OTHER(303),
        TEMPORARY_REDIRECT(307),
        PERMANENT_REDIRECT(308);

        private int code;

        private RedirectStatusCode(int statusCode) {
            this.code = statusCode;
        }

        public int getStatusCode() {
            return this.code;
        }
    }
}

