/*
 * Decompiled with CFR 0.152.
 */
package enkan.util;

import enkan.data.HttpRequest;
import enkan.util.ThreadingUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpRequestUtils {
    private static final Pattern CHARSET_PATTERN = Pattern.compile(";(?:.*\\s)?(?i:charset)=([!#$%&'\\*\\-+\\.0-9A-Z\\^_`a-z\\|~]+|\"(\\\"|[^\"])*\")\\s*(?:;|$)");
    private static final Pattern CONTENT_TYPE_PATTERN = Pattern.compile("^(.*?)(?:;|$)");

    public static String requestUrl(HttpRequest request) {
        StringBuilder sb = new StringBuilder().append(request.getScheme()).append("://").append(request.getHeaders().get("host")).append(request.getUri());
        String queryString = request.getQueryString();
        if (queryString != null) {
            sb.append('?').append(queryString);
        }
        return sb.toString();
    }

    public static String contentType(HttpRequest request) {
        String type = ThreadingUtils.some((Object)((Object)request.getHeaders()), headers -> headers.get("content-type")).orElse(null);
        if (type == null) {
            return null;
        }
        Matcher m = CONTENT_TYPE_PATTERN.matcher(type);
        return m.find() ? m.group(1) : null;
    }

    public static Long contentLength(HttpRequest request) {
        String length = request.getHeaders().get("content-length");
        if (length != null) {
            try {
                return Long.parseLong(length, 10);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String characterEncoding(HttpRequest request) {
        String type = request.getHeaders().get("content-type");
        if (type == null) {
            return null;
        }
        Matcher m = CHARSET_PATTERN.matcher(type);
        return m.find() ? m.group(1) : null;
    }

    public static String pathInfo(HttpRequest request) {
        return request.getUri();
    }

    public static boolean isUrlEncodedForm(HttpRequest request) {
        String type = HttpRequestUtils.contentType(request);
        return type != null && type.startsWith("application/x-www-form-urlencoded");
    }
}

