/*
 * Decompiled with CFR 0.152.
 */
package enkan.middleware.session;

import enkan.middleware.session.KeyValueStore;
import java.io.Serializable;
import java.util.UUID;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.spi.CachingProvider;

public class JCacheStore
implements KeyValueStore {
    private Cache<String, Serializable> cache;

    public JCacheStore() {
        this(null);
    }

    public JCacheStore(Factory<ExpiryPolicy> expiryPolicyFactory) {
        CachingProvider cachingProvider = Caching.getCachingProvider();
        CacheManager cacheManager = cachingProvider.getCacheManager();
        MutableConfiguration config = new MutableConfiguration().setTypes(String.class, Serializable.class);
        if (expiryPolicyFactory != null) {
            config.setExpiryPolicyFactory(expiryPolicyFactory);
        }
        this.cache = cacheManager.getCache("session", String.class, Serializable.class);
        if (this.cache == null) {
            this.cache = cacheManager.createCache("session", (Configuration)config);
        }
    }

    @Override
    public Serializable read(String key) {
        return (Serializable)this.cache.get((Object)key);
    }

    @Override
    public String write(String key, Serializable value) {
        if (key == null) {
            key = UUID.randomUUID().toString();
        }
        this.cache.put((Object)key, (Object)value);
        return key;
    }

    @Override
    public String delete(String key) {
        this.cache.remove((Object)key);
        return key;
    }
}

