/*
 * Decompiled with CFR 0.152.
 */
package enkan.middleware.multipart;

import enkan.collection.Parameters;
import enkan.exception.FalteringEnvironmentException;
import enkan.middleware.multipart.MultipartCollector;
import enkan.middleware.multipart.MultipartInfo;
import enkan.util.CodecUtils;
import enkan.util.SearchUtils;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MultipartParser {
    private static final int DEFAULT_BUFFER_SIZE = 16384;
    private static final String EOL = "\r\n";
    private static final Pattern MULTIPART = Pattern.compile("multipart/.*boundary=\"?([^\";,]+)\"?");
    private static final Pattern TOKEN = Pattern.compile("[^\\s()<>,;:\\\\\"/\\[\\]?=]+");
    private static final Pattern CONDISP = Pattern.compile("Content-Disposition:\\s*" + TOKEN.pattern() + "\\s*", 2);
    private static final Pattern VALUE = Pattern.compile("\"(?:\\\\\"|[^\"])*\"|" + TOKEN.pattern());
    private static final Pattern BROKEN_QUOTED = Pattern.compile(String.format("^%s.*;\\sfilename=\"(.*?)\"(?:\\s*$|\\s*;\\s*%s=)", CONDISP, TOKEN), 10);
    private static final Pattern BROKEN_UNQUOTED = Pattern.compile(String.format("^%s.*;\\sfilename=(%s)", CONDISP, TOKEN), 10);
    private static final Pattern MULTIPART_CONTENT_TYPE = Pattern.compile("Content-Type: (.*)\r\n", 10);
    private static final Pattern MULTIPART_CONTENT_DISPOSITION = Pattern.compile("Content-Disposition:.*\\s+name=(" + VALUE.pattern() + ")", 10);
    private static final Pattern MULTIPART_CONTENT_ID = Pattern.compile("Content-ID:\\s*([^\r\n]*)", 10);
    private static final Pattern ATTRIBUTE_CHAR = Pattern.compile("[^ \\t\\v\\n\\r)(><@,;:\\\\\"/\\[\\]?='*%]");
    private static final Pattern ATTRIBUTE = Pattern.compile(ATTRIBUTE_CHAR.pattern() + "+");
    private static final Pattern SECTION = Pattern.compile("\\*[0-9]+/");
    private static final Pattern REGULAR_PARAMETER_NAME = Pattern.compile(ATTRIBUTE.pattern() + "(?:" + SECTION.pattern() + ")?");
    private static final Pattern REGULAR_PARAMETER = Pattern.compile(String.format("(%s)=(%s)", REGULAR_PARAMETER_NAME.pattern(), VALUE.pattern()));
    private static final Pattern EXTENDED_OTHER_NAME = Pattern.compile(ATTRIBUTE.pattern() + "\\*[1-9][0-9]*\\*");
    private static final Pattern EXTENDED_OTHER_VALUE = Pattern.compile("%[0-9a-fA-F]{2}|" + ATTRIBUTE_CHAR.pattern());
    private static final Pattern EXTENDED_OTHER_PARAMETER = Pattern.compile(String.format("(%s)=((?:%s)*)", EXTENDED_OTHER_NAME.pattern(), EXTENDED_OTHER_VALUE.pattern()));
    private static final Pattern EXTENDED_INITIAL_NAME = Pattern.compile(ATTRIBUTE + "(?:\\*0)?\\*");
    private static final Pattern EXTENDED_INITIAL_VALUE = Pattern.compile("[a-zA-Z0-9\\-]*'[a-zA-Z0-9\\-]*'(?:" + EXTENDED_OTHER_VALUE.pattern() + ")*");
    private static final Pattern EXTENDED_INITIAL_PARAMETER = Pattern.compile(String.format("(%s)=(%s)", EXTENDED_INITIAL_NAME.pattern(), EXTENDED_INITIAL_VALUE.pattern()));
    private static final Pattern EXTENDED_PARAMETER = Pattern.compile(EXTENDED_INITIAL_PARAMETER.pattern() + "|" + EXTENDED_OTHER_PARAMETER.pattern());
    private static final Pattern DISPPARM = Pattern.compile(String.format(";\\s*(?:%s|%s)\\s*", REGULAR_PARAMETER.pattern(), EXTENDED_PARAMETER.pattern()));
    private static final Pattern RFC2183 = Pattern.compile(String.format("^%s(%s)+$", CONDISP.pattern(), DISPPARM.pattern()), 10);
    private static final MultipartInfo EMPTY = new MultipartInfo(null, new ArrayList<File>());
    private static final BiFunction<String, String, File> TEMPFILE_FACTORY = (filename, contentType) -> {
        int idx = filename.indexOf(46);
        String extName = idx >= 0 && idx < filename.length() ? filename.substring(idx) : "";
        try {
            return File.createTempFile("EnkanMultipart", extName);
        }
        catch (IOException e) {
            throw new FalteringEnvironmentException((Throwable)e);
        }
    };
    private ByteBuffer buf;
    private String boundary;
    private ParseState state;
    private int mimeIndex;
    private MultipartCollector collector;

    public MultipartParser(String boundary, int bufferSize) {
        this.boundary = "--" + boundary;
        this.buf = ByteBuffer.allocate(bufferSize);
        this.state = ParseState.FAST_FORWARD;
        this.collector = new MultipartCollector(TEMPFILE_FACTORY);
    }

    public void onRead(byte[] src, int len) throws IOException {
        if (len == 0) {
            throw new EOFException();
        }
        this.buf.put(src, 0, len);
        this.buf.flip();
        this.runParser();
    }

    public Parameters result() {
        Parameters params = Parameters.empty();
        this.collector.stream().forEach(part -> params.putAll((Map)part.getData()));
        return params;
    }

    public static String parseBoundary(String contentType) {
        if (contentType == null) {
            return null;
        }
        Matcher m = MULTIPART.matcher(contentType);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    public static Parameters parse(InputStream in, Long contentLength, String contentType, int bufferSize) throws IOException {
        if (contentLength != null && contentLength == 0L) {
            return Parameters.empty();
        }
        String boundary = MultipartParser.parseBoundary(contentType);
        if (boundary == null) {
            return Parameters.empty();
        }
        if (bufferSize == 0) {
            bufferSize = 16384;
        }
        byte[] buffer = new byte[bufferSize];
        MultipartParser parser = new MultipartParser(boundary, bufferSize);
        int readed = in.read(buffer);
        parser.onRead(buffer, readed);
        while (parser.state != ParseState.DONE) {
            readed = in.read(buffer, 0, parser.buf.remaining());
            parser.onRead(buffer, readed);
        }
        return parser.result();
    }

    private void runParser() throws IOException {
        while (true) {
            switch (this.state) {
                case FAST_FORWARD: {
                    if (!this.handleFastForward()) break;
                    return;
                }
                case CONSUME_TOKEN: {
                    if (!this.handleConsumeToken()) break;
                    return;
                }
                case MIME_HEAD: {
                    if (!this.handleMimeHead()) break;
                    return;
                }
                case MIME_BODY: {
                    if (!this.handleMimeBody()) break;
                    return;
                }
                case DONE: {
                    return;
                }
            }
        }
    }

    private boolean handleFastForward() {
        if (this.consumeBoundary() != BoundaryState.EMPTY) {
            this.state = ParseState.MIME_HEAD;
            return false;
        }
        return true;
    }

    private boolean handleConsumeToken() {
        BoundaryState tok = this.consumeBoundary();
        this.state = tok == BoundaryState.END_BOUNDARY || tok == BoundaryState.EMPTY ? ParseState.DONE : ParseState.MIME_HEAD;
        return false;
    }

    private boolean handleMimeHead() throws IOException {
        this.buf.mark();
        while (this.buf.hasRemaining()) {
            if (this.buf.get() != 13 || !this.buf.hasRemaining() || this.buf.get() != 10 || !this.buf.hasRemaining() || this.buf.get() != 13 || !this.buf.hasRemaining() || this.buf.get() != 10) continue;
            int end = this.buf.position() - 4;
            this.buf.reset();
            int start = this.buf.position();
            byte[] headBuf = new byte[end - start + 2];
            this.buf.get(headBuf);
            String head = new String(headBuf, StandardCharsets.UTF_8);
            for (int i = 0; i < 2; ++i) {
                this.buf.get();
            }
            String contentType = null;
            Matcher contentTypeMatcher = MULTIPART_CONTENT_TYPE.matcher(head);
            if (contentTypeMatcher.find()) {
                contentType = contentTypeMatcher.group(1);
            }
            String name = null;
            Matcher contentDispositionMatcher = MULTIPART_CONTENT_DISPOSITION.matcher(head);
            if (contentDispositionMatcher.find()) {
                name = contentDispositionMatcher.group(1).replaceAll("\"(.*)\"", "$1");
            } else {
                Matcher contentIdMatcher = MULTIPART_CONTENT_ID.matcher(head);
                if (contentIdMatcher.find()) {
                    name = contentIdMatcher.group(1);
                }
            }
            String filename = this.getFilename(head);
            this.collector.onMimeHead(this.mimeIndex, head, filename, contentType, name);
            this.state = ParseState.MIME_BODY;
            return false;
        }
        return true;
    }

    private boolean handleMimeBody() throws IOException {
        byte[] boundaryBytes = this.boundary.getBytes(StandardCharsets.ISO_8859_1);
        byte[] sought = new byte[boundaryBytes.length + 2];
        sought[0] = 13;
        sought[1] = 10;
        System.arraycopy(boundaryBytes, 0, sought, 2, boundaryBytes.length);
        int idx = SearchUtils.kmp((ByteBuffer)this.buf, (byte[])sought);
        int len = idx < 0 ? this.buf.remaining() : idx - this.buf.position();
        byte[] content = new byte[len];
        this.buf.get(content, 0, len);
        this.collector.onMimeBody(this.mimeIndex, content);
        if (idx < 0) {
            this.buf.clear();
            return true;
        }
        if (idx + sought.length + 2 > this.buf.limit()) {
            this.buf.position(idx);
            this.buf.compact();
            this.buf.flip();
            return true;
        }
        this.buf.position(idx + 2);
        this.buf.compact();
        this.buf.flip();
        this.collector.onMimeFinish(this.mimeIndex);
        ++this.mimeIndex;
        this.state = ParseState.CONSUME_TOKEN;
        return false;
    }

    private BoundaryState consumeBoundary() {
        while (true) {
            byte b;
            if (this.buf.hasRemaining() && this.buf.get() == 10) {
                continue;
            }
            if (this.buf.hasRemaining()) {
                this.buf.position(this.buf.position() - 1);
            }
            this.buf.mark();
            while (this.buf.hasRemaining() && (b = this.buf.get()) != 10) {
            }
            int end = this.buf.position() - 1;
            this.buf.reset();
            byte[] boundaryBuf = new byte[end - this.buf.position()];
            this.buf.get(boundaryBuf);
            String readedBoundary = new String(boundaryBuf, StandardCharsets.ISO_8859_1).trim();
            this.buf.get();
            if (readedBoundary.equals(this.boundary)) {
                return BoundaryState.BOUNDARY;
            }
            if (readedBoundary.equals(this.boundary + "--")) {
                return BoundaryState.END_BOUNDARY;
            }
            if (!this.buf.hasRemaining()) break;
        }
        return BoundaryState.EMPTY;
    }

    private String getFilename(String head) {
        String filename = null;
        Matcher rfc2183Matcher = RFC2183.matcher(head);
        Matcher brokenQuotedMatcher = BROKEN_QUOTED.matcher(head);
        Matcher brokenUnQuotedMatcher = BROKEN_UNQUOTED.matcher(head);
        if (rfc2183Matcher.find()) {
            HashMap<String, String> params = new HashMap<String, String>();
            Matcher disparmMatchr = DISPPARM.matcher(head);
            while (disparmMatchr.find()) {
                int cnt = disparmMatchr.groupCount();
                for (int i = 1; i < cnt; i += 2) {
                    if (disparmMatchr.group(i) == null) continue;
                    params.put(disparmMatchr.group(i), disparmMatchr.group(i + 1));
                }
            }
            if (params.containsKey("filename")) {
                filename = ((String)params.get("filename")).replaceAll("^\"(.*)\"$", "$1");
            } else if (params.containsKey("filename*")) {
                String[] tokens = ((String)params.get("filename*")).split("'", 3);
                filename = tokens[2];
                if (Charset.isSupported(tokens[0])) {
                    filename = CodecUtils.urlDecode(filename, tokens[0]);
                }
            }
        } else if (brokenQuotedMatcher.find()) {
            filename = brokenQuotedMatcher.group(1);
        } else if (brokenUnQuotedMatcher.find()) {
            filename = brokenUnQuotedMatcher.group(1);
        }
        if (filename == null) {
            return null;
        }
        if (!(filename = CodecUtils.urlDecode(filename)).matches("\\[^\"]")) {
            filename = filename.replaceAll("\\\\(.)", "$1");
        }
        return filename;
    }

    private static enum BoundaryState {
        BOUNDARY,
        END_BOUNDARY,
        EMPTY;

    }

    private static enum ParseState {
        FAST_FORWARD,
        CONSUME_TOKEN,
        MIME_HEAD,
        MIME_BODY,
        DONE;

    }
}

