/*
 * Decompiled with CFR 0.152.
 */
package enkan.middleware.multipart;

import enkan.middleware.multipart.BufferPart;
import enkan.middleware.multipart.MimePart;
import enkan.middleware.multipart.TempfilePart;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Stream;

public class MultipartCollector {
    private BiFunction<String, String, File> tempfileFactory;
    private List<MimePart> mimeParts = new ArrayList<MimePart>();

    public MultipartCollector(BiFunction<String, String, File> tempfileFactory) {
        this.tempfileFactory = tempfileFactory;
    }

    public void onMimeHead(int mimeIndex, String head, String filename, String contentType, String name) throws IOException {
        if (filename != null) {
            File tempfile = this.tempfileFactory.apply(filename, contentType);
            this.mimeParts.add(new TempfilePart(tempfile, head, filename, contentType, name));
        } else {
            this.mimeParts.add(new BufferPart(head, null, contentType, name));
        }
    }

    public void onMimeBody(int mimeIndex, byte[] content) throws IOException {
        this.mimeParts.get(mimeIndex).getBody().write(content);
    }

    public void onMimeFinish(int mimeIndex) {
        this.mimeParts.get(mimeIndex).close();
    }

    public Stream<MimePart> stream() {
        return this.mimeParts.stream();
    }
}

