/*
 * Decompiled with CFR 0.152.
 */
package enkan.middleware;

import enkan.MiddlewareChain;
import enkan.annotation.Middleware;
import enkan.collection.OptionMap;
import enkan.data.HttpRequest;
import enkan.data.HttpResponse;
import enkan.middleware.AbstractWebMiddleware;
import enkan.util.HttpResponseUtils;

@Middleware(name="xssProtection")
public class XssProtectionMiddleware<NRES>
extends AbstractWebMiddleware<HttpRequest, NRES> {
    private String headerValue;

    public XssProtectionMiddleware() {
        this(true, OptionMap.of((Object[])new Object[]{"mode", "block"}));
    }

    public XssProtectionMiddleware(boolean enable, OptionMap options) {
        StringBuilder sb = new StringBuilder();
        sb.append(enable ? "1" : "0");
        String mode = options.getString("mode");
        if (mode != null) {
            sb.append("; mode=").append(mode);
        }
        this.headerValue = sb.toString();
    }

    public HttpResponse handle(HttpRequest httpRequest, MiddlewareChain<HttpRequest, NRES, ?, ?> chain) {
        HttpResponse response = this.castToHttpResponse(chain.next((Object)httpRequest));
        if (response != null) {
            HttpResponseUtils.header(response, "X-XSS-Protection", this.headerValue);
        }
        return response;
    }
}

