/*
 * Decompiled with CFR 0.152.
 */
package enkan.middleware;

import enkan.MiddlewareChain;
import enkan.annotation.Middleware;
import enkan.collection.OptionMap;
import enkan.data.Cookie;
import enkan.data.HttpRequest;
import enkan.data.HttpResponse;
import enkan.data.PersistentMarkedSession;
import enkan.data.Session;
import enkan.data.WebSessionAvailable;
import enkan.middleware.AbstractWebMiddleware;
import enkan.middleware.session.KeyValueStore;
import enkan.middleware.session.MemoryStore;
import enkan.util.MixinUtils;
import enkan.util.ThreadingUtils;
import java.io.Serializable;
import javax.validation.constraints.NotNull;

@Middleware(name="session", dependencies={"cookies"})
public class SessionMiddleware<NRES>
extends AbstractWebMiddleware<HttpRequest, NRES> {
    @NotNull
    private String cookieName = "enkan-session";
    private OptionMap cookieAttrs;
    @NotNull
    private KeyValueStore store = new MemoryStore();

    public SessionMiddleware() {
        this.cookieAttrs = OptionMap.of((Object[])new Object[]{"httpOnly", true, "path", "/"});
    }

    protected void populteAttrs(Cookie cookie) {
        if (this.cookieAttrs.containsValue((Object)"domain")) {
            cookie.setDomain(this.cookieAttrs.getString("domain"));
        }
        if (this.cookieAttrs.containsValue((Object)"path")) {
            cookie.setPath(this.cookieAttrs.getString("path"));
        }
        if (this.cookieAttrs.containsValue((Object)"secure")) {
            cookie.setSecure(this.cookieAttrs.getBoolean("secure"));
        }
        if (this.cookieAttrs.containsValue((Object)"httpOnly")) {
            cookie.setHttpOnly(this.cookieAttrs.getBoolean("httpOnly"));
        }
    }

    protected void sessionRequest(HttpRequest request) {
        ThreadingUtils.some(request.getCookies(), cs -> (Cookie)cs.get(this.cookieName)).ifPresent(sessionCookie -> {
            String reqKey = sessionCookie.getValue();
            Session session = reqKey != null ? (Session)this.store.read(reqKey) : null;
            request.setSession(session);
            if (session != null) {
                ((WebSessionAvailable)((Object)request)).setSessionKey(reqKey);
            }
        });
    }

    protected void sessionResponse(HttpResponse response, HttpRequest request) {
        String sessionKey = null;
        if (request instanceof WebSessionAvailable) {
            sessionKey = ((WebSessionAvailable)((Object)request)).getSessionKey();
        }
        if (response instanceof WebSessionAvailable) {
            Session session = response.getSession();
            if (session == null || session.isNew() && request.getSession() != null) {
                this.store.delete(sessionKey);
            }
            String newSessionKey = null;
            if (session != null && !PersistentMarkedSession.class.isInstance(session)) {
                session.persist();
                newSessionKey = this.store.write(sessionKey, (Serializable)session);
            }
            Cookie cookie = Cookie.create(this.cookieName, newSessionKey != null ? newSessionKey : sessionKey);
            this.populteAttrs(cookie);
            if (newSessionKey != null && !newSessionKey.equals(sessionKey)) {
                response.getCookies().put((Object)this.cookieName, (Object)cookie);
            }
        }
    }

    public HttpResponse handle(HttpRequest request, MiddlewareChain<HttpRequest, NRES, ?, ?> chain) {
        request = (HttpRequest)MixinUtils.mixin((Object)request, (Class[])new Class[]{WebSessionAvailable.class});
        this.sessionRequest(request);
        HttpResponse response = this.castToHttpResponse(chain.next((Object)request));
        response = (HttpResponse)MixinUtils.mixin((Object)response, (Class[])new Class[]{WebSessionAvailable.class});
        this.sessionResponse(response, request);
        return response;
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    public void setCookieAttrs(OptionMap cookieAttrs) {
        this.cookieAttrs = cookieAttrs;
    }

    public void setStore(KeyValueStore store) {
        this.store = store;
    }
}

