/*
 * Decompiled with CFR 0.152.
 */
package enkan.middleware;

import enkan.MiddlewareChain;
import enkan.annotation.Middleware;
import enkan.collection.OptionMap;
import enkan.data.HttpRequest;
import enkan.data.HttpResponse;
import enkan.middleware.AbstractWebMiddleware;
import enkan.util.CodecUtils;
import enkan.util.HttpRequestUtils;
import enkan.util.HttpResponseUtils;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;

@Middleware(name="resource")
public class ResourceMiddleware<NRES>
extends AbstractWebMiddleware<HttpRequest, NRES> {
    private String rootPath = "public";
    private String uriPrefix = "assets/";
    private static final Set<String> ACCEPTABLE_METHODS = new HashSet<String>(){
        {
            this.add("GET");
            this.add("HEAD");
        }
    };

    protected HttpResponse resourceRequest(HttpRequest request, String rootPath) {
        if (ACCEPTABLE_METHODS.contains(Objects.toString(request.getRequestMethod(), "").toUpperCase(Locale.ENGLISH))) {
            String path = CodecUtils.urlDecode(HttpRequestUtils.pathInfo(request)).substring(1);
            if (!path.startsWith(this.uriPrefix)) {
                return null;
            }
            int len = this.uriPrefix.length();
            if (len > 0) {
                path = path.substring(len);
            }
            return HttpResponseUtils.resourceResponse(path, OptionMap.of((Object[])new Object[]{"root", rootPath}));
        }
        return null;
    }

    public HttpResponse handle(HttpRequest request, MiddlewareChain<HttpRequest, NRES, ?, ?> chain) {
        HttpResponse response = this.resourceRequest(request, this.rootPath);
        if (response == null) {
            response = this.castToHttpResponse(chain.next((Object)request));
        }
        return response;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public void setUriPrefix(String uriPrefix) {
        if (uriPrefix == null) {
            this.uriPrefix = "";
        } else {
            if (uriPrefix.startsWith("/")) {
                uriPrefix = uriPrefix.substring(1);
            }
            if (!uriPrefix.endsWith("/")) {
                uriPrefix = uriPrefix + "/";
            }
            this.uriPrefix = uriPrefix;
        }
    }
}

