/*
 * Decompiled with CFR 0.152.
 */
package enkan.middleware;

import enkan.MiddlewareChain;
import enkan.annotation.Middleware;
import enkan.collection.Parameters;
import enkan.data.HttpRequest;
import enkan.data.HttpResponse;
import enkan.exception.FalteringEnvironmentException;
import enkan.middleware.AbstractWebMiddleware;
import enkan.util.CodecUtils;
import enkan.util.HttpRequestUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;

@Middleware(name="params")
public class ParamsMiddleware<NRES>
extends AbstractWebMiddleware<HttpRequest, NRES> {
    protected Parameters parseParams(String urlencodedParams, String encoding) {
        Parameters params = CodecUtils.formDecode(urlencodedParams, encoding);
        return params == null ? Parameters.empty() : params;
    }

    protected void parseQueryParams(HttpRequest request, String encoding) {
        String queryString = request.getQueryString();
        if (queryString == null) {
            request.setQueryParams(Parameters.empty());
            if (request.getParams() == null) {
                request.setParams(Parameters.empty());
            }
        } else {
            Parameters params = this.parseParams(queryString, encoding);
            request.setQueryParams(params);
            Parameters current = request.getParams();
            if (current == null) {
                request.setParams(params);
            } else {
                current.putAll((Map)params);
            }
        }
    }

    protected void parseFormParams(HttpRequest request, String encoding) {
        InputStream body = request.getBody();
        if (HttpRequestUtils.isUrlEncodedForm(request) && body != null) {
            StringBuilder sb = new StringBuilder();
            try (InputStreamReader reader = new InputStreamReader(body, encoding);){
                int c;
                while ((c = reader.read()) >= 0) {
                    sb.append((char)c);
                }
            }
            catch (IOException e) {
                throw new FalteringEnvironmentException((Throwable)e);
            }
            Parameters params = this.parseParams(sb.toString(), encoding);
            request.setFormParams(params);
            Parameters current = request.getParams();
            if (current == null) {
                request.setParams(params);
            } else {
                current.putAll((Map)params);
            }
        } else {
            request.setFormParams(Parameters.empty());
            if (request.getParams() == null) {
                request.setParams(Parameters.empty());
            }
        }
    }

    public void paramsRequest(HttpRequest request) {
        Parameters queryParams;
        Parameters formParams;
        String encoding = HttpRequestUtils.characterEncoding(request);
        if (encoding == null) {
            encoding = "UTF-8";
        }
        if ((formParams = request.getFormParams()) == null) {
            this.parseFormParams(request, encoding);
        }
        if ((queryParams = request.getQueryParams()) == null) {
            this.parseQueryParams(request, encoding);
        }
    }

    public HttpResponse handle(HttpRequest httpRequest, MiddlewareChain<HttpRequest, NRES, ?, ?> next) {
        this.paramsRequest(httpRequest);
        return this.castToHttpResponse(next.next((Object)httpRequest));
    }
}

