/*
 * Decompiled with CFR 0.152.
 */
package enkan.middleware;

import enkan.MiddlewareChain;
import enkan.annotation.Middleware;
import enkan.collection.Parameters;
import enkan.data.HttpRequest;
import enkan.data.HttpResponse;
import enkan.middleware.AbstractWebMiddleware;
import enkan.middleware.normalizer.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

@Middleware(name="normalization", dependencies={"params"})
public class NormalizationMiddleware<NRES>
extends AbstractWebMiddleware<HttpRequest, NRES> {
    private List<NormalizationSpec<Object>> normalizationSpecs = new ArrayList<NormalizationSpec<Object>>();

    public NormalizationMiddleware() {
    }

    public NormalizationMiddleware(NormalizationSpec<Object> spec, NormalizationSpec<Object> ... specs) {
        this();
        this.normalizationSpecs.add(spec);
        this.normalizationSpecs.addAll(Arrays.asList(specs));
    }

    public static <T> NormalizationSpec<T> normalization(Predicate<String> predicate, Normalizer<T> normalizer) {
        return new NormalizationSpec<T>(predicate, normalizer);
    }

    public HttpResponse handle(HttpRequest request, MiddlewareChain<HttpRequest, NRES, ?, ?> chain) {
        Parameters params = request.getParams();
        if (params != null) {
            params.keySet().forEach(key -> {
                Object obj = params.getRawType(key);
                if (obj == null) {
                    return;
                }
                this.normalizationSpecs.forEach(c -> {
                    if (c.getPredicate().test((String)key) && c.getNormalizer().canNormalize(obj.getClass())) {
                        params.replace(key, c.getNormalizer().normalize(obj));
                    }
                });
            });
        }
        return this.castToHttpResponse(chain.next((Object)request));
    }

    public static class NormalizationSpec<T> {
        private Normalizer<T> normalizer;
        private Predicate<String> predicate;

        public NormalizationSpec(Predicate<String> predicate, Normalizer<T> normalizer) {
            this.predicate = predicate;
            this.normalizer = normalizer;
        }

        public Normalizer<T> getNormalizer() {
            return this.normalizer;
        }

        public Predicate<String> getPredicate() {
            return this.predicate;
        }
    }
}

