/*
 * Decompiled with CFR 0.152.
 */
package enkan.middleware;

import enkan.MiddlewareChain;
import enkan.annotation.Middleware;
import enkan.collection.Parameters;
import enkan.data.HttpRequest;
import enkan.data.HttpResponse;
import enkan.middleware.AbstractWebMiddleware;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Middleware(name="nestedParams", dependencies={"params"})
public class NestedParamsMiddleware<NRES>
extends AbstractWebMiddleware<HttpRequest, NRES> {
    private static final Pattern RE_NESTED_NAME = Pattern.compile("^(?s)(.*?)((?:\\[.*?\\])*)$");
    private static final Pattern RE_NESTED_TOKEN = Pattern.compile("\\[(.*?)\\]");
    protected Function<String, String[]> parseNestedKeys = paramName -> {
        if (paramName == null) {
            return new String[0];
        }
        Matcher m = RE_NESTED_NAME.matcher((CharSequence)paramName);
        ArrayList<String> keys = new ArrayList<String>();
        if (m.find()) {
            keys.add(m.group(1));
            String ks = m.group(2);
            if (ks != null && !ks.isEmpty()) {
                Matcher mt = RE_NESTED_TOKEN.matcher(ks);
                while (mt.find()) {
                    keys.add(mt.group(1));
                }
            } else {
                return new String[]{m.group(1)};
            }
        }
        return keys.toArray(new String[keys.size()]);
    };

    protected Parameters assocVector(Parameters map, String key, Object value) {
        if (!map.containsKey((Object)key)) {
            map.put(key, new ArrayList());
        }
        return this.assocConj(map, key, value);
    }

    protected Parameters assocConj(Parameters map, String key, Object value) {
        Object cur = map.getRawType((Object)key);
        if (cur != null) {
            if (cur instanceof List) {
                if (value instanceof List) {
                    ((List)cur).addAll((List)value);
                } else {
                    ((List)cur).add(value);
                }
            } else {
                ArrayList<Object> values = new ArrayList<Object>();
                values.add(cur);
                if (value instanceof List) {
                    values.addAll((List)value);
                } else {
                    values.add(value);
                }
                map.put(key, values);
            }
        } else if (value instanceof List) {
            List values = (List)value;
            if (values.size() > 1) {
                this.assocVector(map, key, value);
            } else if (values.size() == 1) {
                map.put(key, values.get(0));
            }
        } else {
            map.put(key, value);
        }
        return map;
    }

    protected Object assocNested(Parameters map, String[] keys, List<String> values) {
        if (keys.length > 0) {
            String[] ks = new String[keys.length - 1];
            if (ks.length > 0) {
                System.arraycopy(keys, 1, ks, 0, ks.length);
                String j = ks[0];
                if (j.isEmpty()) {
                    int i;
                    String[] js = new String[keys.length - 2];
                    if (js.length > 0) {
                        System.arraycopy(keys, 2, js, 0, js.length);
                    }
                    List nestedList = map.getList((Object)keys[0], new Object[0]);
                    for (i = nestedList.size(); i < values.size(); ++i) {
                        nestedList.add(null);
                    }
                    for (i = 0; i < values.size(); ++i) {
                        ArrayList<String> vs = new ArrayList<String>();
                        vs.add(values.get(i));
                        if (js.length > 0) {
                            nestedList.set(i, this.assocNested(Optional.ofNullable(nestedList.get(i)).orElse(Parameters.empty()), js, vs));
                            continue;
                        }
                        nestedList.set(i, vs.get(0));
                    }
                    if (map.containsKey((Object)keys[0])) {
                        map.replace(keys[0], (Object)nestedList);
                    } else {
                        map.put(keys[0], (Object)nestedList);
                    }
                    return map;
                }
                Parameters submap = (Parameters)map.getRawType((Object)keys[0]);
                if (submap == null) {
                    submap = Parameters.empty();
                }
                map.put(keys[0], this.assocNested(submap, ks, values));
                return map;
            }
            return this.assocConj(map, keys[0], values);
        }
        return values;
    }

    public HttpRequest nestedParamsRequest(HttpRequest request, Function<String, String[]> keyParser) {
        Parameters params = request.getParams();
        Parameters nestedParams = Parameters.empty();
        params.keySet().forEach(key -> this.assocNested(nestedParams, (String[])keyParser.apply((String)key), params.getList(key, new Object[0])));
        request.setParams(nestedParams);
        return request;
    }

    public HttpResponse handle(HttpRequest request, MiddlewareChain<HttpRequest, NRES, ?, ?> chain) {
        return this.castToHttpResponse(chain.next((Object)this.nestedParamsRequest(request, this.parseNestedKeys)));
    }
}

