/*
 * Decompiled with CFR 0.152.
 */
package enkan.middleware;

import enkan.MiddlewareChain;
import enkan.annotation.Middleware;
import enkan.collection.Parameters;
import enkan.data.HttpRequest;
import enkan.data.HttpResponse;
import enkan.exception.FalteringEnvironmentException;
import enkan.middleware.AbstractWebMiddleware;
import enkan.middleware.multipart.MultipartParser;
import enkan.util.HttpRequestUtils;
import enkan.util.ThreadingUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Map;
import java.util.Optional;

@Middleware(name="multipartParams", dependencies={"params"})
public class MultipartParamsMiddleware<NRES>
extends AbstractWebMiddleware<HttpRequest, NRES> {
    protected void deleteTempfile(Parameters multipartParams) {
        multipartParams.keySet().stream().filter(k -> {
            Object v = multipartParams.getIn(k, new Object[0]);
            return v instanceof Parameters && ((Parameters)v).getIn((Object)"tempfile", new Object[0]) instanceof File;
        }).forEach(k -> {
            Optional tempfile = ThreadingUtils.some((Object)((File)multipartParams.getIn(k, new Object[]{"tempfile"})), File::toPath);
            tempfile.ifPresent(f -> {
                try {
                    Files.deleteIfExists(f);
                }
                catch (IOException ex) {
                    throw new FalteringEnvironmentException((Throwable)ex);
                }
            });
        });
    }

    protected Parameters extractMultipart(HttpRequest request) {
        try {
            return MultipartParser.parse(request.getBody(), HttpRequestUtils.contentLength(request), request.getHeaders().get("content-type"), 16384);
        }
        catch (IOException e) {
            throw new FalteringEnvironmentException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse handle(HttpRequest request, MiddlewareChain<HttpRequest, NRES, ?, ?> chain) {
        Parameters multipartParams = this.extractMultipart(request);
        request.getParams().putAll((Map)multipartParams);
        try {
            HttpResponse httpResponse = this.castToHttpResponse(chain.next((Object)request));
            return httpResponse;
        }
        finally {
            this.deleteTempfile(multipartParams);
        }
    }
}

