/*
 * Decompiled with CFR 0.152.
 */
package enkan.middleware;

import enkan.MiddlewareChain;
import enkan.annotation.Middleware;
import enkan.data.HttpRequest;
import enkan.data.HttpResponse;
import enkan.middleware.AbstractWebMiddleware;
import java.util.Optional;
import java.util.function.Function;

@Middleware(name="methodOverride", dependencies={"params"})
public class MethodOverrideMiddleware<NRES>
extends AbstractWebMiddleware<HttpRequest, NRES> {
    private Function<HttpRequest, String> getterFunction = this.createGetter("_method");

    public void setGetterFunction(String functionName) {
        this.getterFunction = this.createGetter(functionName);
    }

    public void setGetterFunction(Function<HttpRequest, String> getterFunction) {
        this.getterFunction = getterFunction;
    }

    protected Function<HttpRequest, String> createQueryGetter(String key) {
        return req -> req.getParams().get((Object)key);
    }

    protected Function<HttpRequest, String> createHeaderGetter(String str) {
        String header = str.toLowerCase();
        return req -> Optional.ofNullable(req.getHeaders().get(header)).orElse("");
    }

    protected Function<HttpRequest, String> createGetter(String str) {
        if (str.substring(0, 2).toUpperCase().equals("X-")) {
            return this.createHeaderGetter(str);
        }
        return this.createQueryGetter(str);
    }

    public HttpResponse handle(HttpRequest request, MiddlewareChain<HttpRequest, NRES, ?, ?> chain) {
        String val = this.getterFunction.apply(request);
        if (val != null) {
            request.setRequestMethod(val);
        }
        return this.castToHttpResponse(chain.next((Object)request));
    }
}

