/*
 * Decompiled with CFR 0.152.
 */
package enkan.middleware;

import enkan.Endpoint;
import enkan.MiddlewareChain;
import enkan.annotation.Middleware;
import enkan.data.HttpRequest;
import enkan.data.HttpResponse;
import enkan.data.Session;
import enkan.data.SessionAvailable;
import enkan.middleware.AbstractWebMiddleware;
import enkan.util.BeanBuilder;
import enkan.util.HttpResponseUtils;
import enkan.util.ThreadingUtils;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;

@Middleware(name="idleSessionTimeout", dependencies={"session"})
public class IdleSessionTimeoutMiddleware<NRES>
extends AbstractWebMiddleware<HttpRequest, NRES> {
    private long timeout = 600L;
    private Endpoint<HttpRequest, HttpResponse> timeoutEndpoint = req -> HttpResponseUtils.redirect("/", HttpResponseUtils.RedirectStatusCode.TEMPORARY_REDIRECT);
    private static final String SESSION_KEY = IdleSessionTimeoutMiddleware.class.getName() + "/idleTimeout";

    private Long currentTime() {
        return System.currentTimeMillis() / 1000L;
    }

    public HttpResponse handle(HttpRequest request, MiddlewareChain<HttpRequest, NRES, ?, ?> chain) {
        Optional endTime = ThreadingUtils.some((Object)request.getSession(), session -> session.get((Object)SESSION_KEY), obj -> Long.parseLong(Objects.toString(obj)));
        if (endTime.isPresent() && (Long)endTime.get() < this.currentTime()) {
            return (HttpResponse)BeanBuilder.builder((Object)((HttpResponse)this.timeoutEndpoint.handle((Object)request))).set(SessionAvailable::setSession, null).build();
        }
        HttpResponse response = this.castToHttpResponse(chain.next((Object)request));
        Long nextEndTime = this.currentTime() + this.timeout;
        Session session2 = Optional.ofNullable(response.getSession()).orElse(request.getSession());
        if (session2 != null) {
            session2.put(SESSION_KEY, (Serializable)nextEndTime);
            response.setSession(session2);
        }
        return response;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

