/*
 * Decompiled with CFR 0.152.
 */
package enkan.middleware;

import enkan.MiddlewareChain;
import enkan.annotation.Middleware;
import enkan.collection.Parameters;
import enkan.data.HttpRequest;
import enkan.data.HttpResponse;
import enkan.exception.MisconfigurationException;
import enkan.middleware.AbstractWebMiddleware;
import enkan.util.HttpResponseUtils;
import java.util.Locale;

@Middleware(name="frameOptions")
public class FrameOptionsMiddleware<NRES>
extends AbstractWebMiddleware<HttpRequest, NRES> {
    private Object frameOptions = "sameorigin";

    private String formatFrameOptions() {
        if (this.frameOptions instanceof Parameters) {
            return "ALLOW-FROM " + ((Parameters)this.frameOptions).get((Object)"allow-from");
        }
        return this.frameOptions.toString().toUpperCase(Locale.US);
    }

    public HttpResponse handle(HttpRequest request, MiddlewareChain<HttpRequest, NRES, ?, ?> chain) {
        String headerValue = this.formatFrameOptions();
        HttpResponse response = this.castToHttpResponse(chain.next((Object)request));
        HttpResponseUtils.header(response, "X-Frame-Options", headerValue);
        return response;
    }

    public void setFrameOptions(String frameOptions) {
        this.frameOptions = frameOptions;
    }

    public void setFrameOptions(Parameters frameOptions) {
        if (!frameOptions.containsKey((Object)"allow-from")) {
            throw new MisconfigurationException("web.ILLEGAL_FRAME_OPTIONS", new Object[0]);
        }
        this.frameOptions = frameOptions;
    }
}

