/*
 * Decompiled with CFR 0.152.
 */
package enkan.middleware;

import enkan.MiddlewareChain;
import enkan.annotation.Middleware;
import enkan.data.HttpRequest;
import enkan.data.HttpResponse;
import enkan.middleware.AbstractWebMiddleware;
import enkan.util.ThreadingUtils;
import java.util.Locale;

@Middleware(name="forwardedScheme")
public class ForwardedSchemeMiddleware<NRES>
extends AbstractWebMiddleware<HttpRequest, NRES> {
    private String header = "x-forwarded-proto";

    private HttpRequest forwardedSchemeRequest(HttpRequest request) {
        String scheme = ThreadingUtils.some((Object)request.getHeaders().get(this.header.toLowerCase(Locale.US)), String::toLowerCase).orElse(null);
        if ("http".equals(scheme) || "https".equals(scheme)) {
            request.setScheme(scheme);
        }
        return request;
    }

    public HttpResponse handle(HttpRequest request, MiddlewareChain<HttpRequest, NRES, ?, ?> chain) {
        return this.castToHttpResponse(chain.next((Object)this.forwardedSchemeRequest(request)));
    }

    public void setHeader(String header) {
        this.header = header;
    }
}

