/*
 * Decompiled with CFR 0.152.
 */
package enkan.middleware;

import enkan.MiddlewareChain;
import enkan.annotation.Middleware;
import enkan.data.Flash;
import enkan.data.FlashAvailable;
import enkan.data.HttpRequest;
import enkan.data.HttpResponse;
import enkan.data.PersistentMarkedSession;
import enkan.data.Session;
import enkan.middleware.AbstractWebMiddleware;
import enkan.util.MixinUtils;
import java.io.Serializable;

@Middleware(name="flash", dependencies={"session"})
public class FlashMiddleware<NRES>
extends AbstractWebMiddleware<HttpRequest, NRES> {
    private String flashKey = "_flash";

    protected void flashRequest(HttpRequest request) {
        Session session = request.getSession();
        if (session != null && session.containsKey((Object)this.flashKey)) {
            request.setFlash((Flash)session.remove((Object)this.flashKey));
        }
    }

    protected void flashResponse(HttpResponse response, HttpRequest request) {
        Flash responseFlash;
        if (response == null) {
            return;
        }
        Session session = response.getSession();
        if (session == null || PersistentMarkedSession.class.isInstance(session)) {
            session = request.getSession();
        }
        if ((responseFlash = ((FlashAvailable)FlashAvailable.class.cast(response)).getFlash()) != null) {
            if (session == null) {
                session = new Session();
            }
            session.put(this.flashKey, (Serializable)responseFlash);
        }
        if (session != null) {
            response.setSession(session);
        }
    }

    public HttpResponse handle(HttpRequest request, MiddlewareChain<HttpRequest, NRES, ?, ?> next) {
        request = (HttpRequest)MixinUtils.mixin((Object)request, (Class[])new Class[]{FlashAvailable.class});
        this.flashRequest(request);
        HttpResponse response = this.castToHttpResponse(next.next((Object)request));
        response = (HttpResponse)MixinUtils.mixin((Object)response, (Class[])new Class[]{FlashAvailable.class});
        this.flashResponse(response, request);
        return response;
    }

    public void setFlashKey(String flashKey) {
        this.flashKey = flashKey;
    }
}

