/*
 * Decompiled with CFR 0.152.
 */
package enkan.middleware;

import enkan.MiddlewareChain;
import enkan.annotation.Middleware;
import enkan.data.HttpRequest;
import enkan.data.HttpResponse;
import enkan.middleware.AbstractWebMiddleware;
import enkan.util.HttpResponseUtils;

@Middleware(name="defaultCharset")
public class DefaultCharsetMiddleware<NRES>
extends AbstractWebMiddleware<HttpRequest, NRES> {
    private String defaultCharset = "UTF-8";

    protected boolean isTextBasedContentType(String contentType) {
        return contentType != null && (contentType.startsWith("text/") || contentType.startsWith("application/xml"));
    }

    protected boolean isContainsCharset(String contentType) {
        return contentType != null && contentType.matches(";\\s*charset=[^;]*");
    }

    protected void addCharset(HttpResponse response, String charset) {
        String contentType = (String)HttpResponseUtils.getHeader(response, "Content-Type");
        if (this.isTextBasedContentType(contentType) && !this.isContainsCharset(contentType)) {
            HttpResponseUtils.charset(response, charset);
        }
    }

    public HttpResponse handle(HttpRequest request, MiddlewareChain<HttpRequest, NRES, ?, ?> chain) {
        HttpResponse response = this.castToHttpResponse(chain.next((Object)request));
        if (response != null) {
            this.addCharset(response, this.defaultCharset);
        }
        return response;
    }

    public void setDefaultCharset(String defaultCharset) {
        this.defaultCharset = defaultCharset;
    }
}

