/*
 * Decompiled with CFR 0.152.
 */
package enkan.middleware;

import enkan.MiddlewareChain;
import enkan.annotation.Middleware;
import enkan.collection.Headers;
import enkan.data.HttpRequest;
import enkan.data.HttpResponse;
import enkan.middleware.AbstractWebMiddleware;
import enkan.util.BeanBuilder;
import enkan.util.HttpResponseUtils;
import enkan.util.ThreadingUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;

@Middleware(name="cors")
public class CorsMiddleware<NRES>
extends AbstractWebMiddleware<HttpRequest, NRES> {
    private Set<String> methods = new HashSet<String>(Arrays.asList("GET", "POST", "DELETE", "PUT", "PATCH", "HEAD", "OPTIONS"));
    private Set<String> origins = new HashSet<String>(Collections.singletonList("*"));
    private Set<String> headers = new HashSet<String>(Arrays.asList("Origin", "Accept", "X-Requested-With", "Content-Type", "Access-Control-Request-Method", "Access-Control-Request-Headers"));
    private Long maxage = 1800L;
    private boolean credentials = true;

    public HttpResponse handle(HttpRequest request, MiddlewareChain<HttpRequest, NRES, ?, ?> chain) {
        if (this.isCORSRequest(request)) {
            if (!this.isOriginAllowed(request) || this.methods.stream().noneMatch(x -> x.equalsIgnoreCase(request.getRequestMethod()))) {
                return this.invalidCors(request);
            }
            if (this.isPreflightRequest(request)) {
                Headers responseHeaders = Headers.empty();
                if (this.isAnyOriginAllowed()) {
                    responseHeaders.put("Access-Control-Allow-Origin", "*");
                } else {
                    String origin = ThreadingUtils.some((Object)((Object)request.getHeaders()), headers -> headers.get("origin")).orElse("*");
                    responseHeaders.put("Access-Control-Allow-Origin", origin);
                }
                if (this.methods != null && !this.methods.isEmpty()) {
                    responseHeaders.put("Access-Control-Allow-Methods", String.join((CharSequence)", ", this.methods));
                }
                if (this.headers != null && !this.headers.isEmpty()) {
                    responseHeaders.put("Access-Control-Allow-Headers", String.join((CharSequence)", ", this.headers));
                }
                if (this.credentials) {
                    responseHeaders.put("Access-Control-Allow-Credentials", "true");
                }
                if (this.maxage > 0L) {
                    responseHeaders.put("Access-Control-Max-Age", String.valueOf(this.maxage));
                }
                return (HttpResponse)BeanBuilder.builder((Object)HttpResponse.of("")).set(HttpResponse::setStatus, (Object)200).set(HttpResponse::setHeaders, (Object)responseHeaders).build();
            }
        }
        HttpResponse response = this.castToHttpResponse(chain.next((Object)request));
        if (this.isCORSRequest(request)) {
            if (this.origins != null && !this.origins.isEmpty()) {
                HttpResponseUtils.header(response, "Access-Control-Allow-Origin", String.join((CharSequence)", ", this.origins));
            }
            if (this.credentials) {
                HttpResponseUtils.header(response, "Access-Control-Allow-Credentials", "true");
            }
        }
        return response;
    }

    private HttpResponse invalidCors(HttpRequest request) {
        return (HttpResponse)BeanBuilder.builder((Object)HttpResponse.of("Invalid CORS request; Origin=" + request.getHeaders().get("origin") + ", Method=" + request.getRequestMethod())).set(HttpResponse::setHeaders, (Object)Headers.of("Content-Type", "text/plain")).set(HttpResponse::setStatus, (Object)403).build();
    }

    private boolean isOriginAllowed(HttpRequest request) {
        return ThreadingUtils.some((Object)((Object)request.getHeaders()), headers -> headers.get("origin"), origin -> this.isAnyOriginAllowed() || this.origins.contains(origin)).orElse(false);
    }

    private boolean isAnyOriginAllowed() {
        return this.origins.contains("*");
    }

    private boolean isPreflightRequest(HttpRequest httpRequest) {
        return Objects.equals(httpRequest.getRequestMethod().toUpperCase(Locale.ENGLISH), "OPTIONS") && httpRequest.getHeaders().containsKey("Access-Control-Request-Method");
    }

    private boolean isCORSRequest(HttpRequest httpRequest) {
        return Objects.nonNull(httpRequest.getHeaders().get("Origin"));
    }

    public void setMethods(Set<String> methods) {
        this.methods = methods;
    }

    public void setOrigins(Set<String> origins) {
        this.origins = origins;
    }

    public void setHeaders(Set<String> headers) {
        this.headers = headers;
    }

    public void setMaxage(Long maxage) {
        this.maxage = maxage;
    }

    public void setCredentials(boolean credentials) {
        this.credentials = credentials;
    }
}

