/*
 * Decompiled with CFR 0.152.
 */
package enkan.middleware;

import enkan.MiddlewareChain;
import enkan.annotation.Middleware;
import enkan.collection.Multimap;
import enkan.data.Cookie;
import enkan.data.HttpRequest;
import enkan.data.HttpResponse;
import enkan.middleware.AbstractWebMiddleware;
import enkan.util.CodecUtils;
import enkan.util.HttpDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Middleware(name="cookies")
public class CookiesMiddleware<NRES>
extends AbstractWebMiddleware<HttpRequest, NRES> {
    private static final Pattern RE_COOKIE_OCTET = Pattern.compile("[!#$%&'()*+\\-./0-9:<=>?@A-Z\\[\\]\\^_`a-z\\{\\|\\}~]");
    private static final Pattern RE_COOKIE_VALUE = Pattern.compile("\"" + RE_COOKIE_OCTET.pattern() + "*\"|" + RE_COOKIE_OCTET.pattern() + "*");
    private static final Pattern RE_COOKIE = Pattern.compile("\\s*([!#$%&'\\*\\-+\\.0-9A-Z\\^_`a-z\\|~]+)=(" + RE_COOKIE_VALUE.pattern() + ")\\s*[;,]?");

    protected String stripQuotes(String value) {
        return value.replaceAll("^\"|\"$", "");
    }

    protected Map<String, Cookie> parseCookies(HttpRequest request) {
        String cookieHeader = request.getHeaders().get("cookie");
        HashMap<String, Cookie> cookies = new HashMap<String, Cookie>();
        if (cookieHeader != null) {
            Matcher m = RE_COOKIE.matcher(cookieHeader);
            while (m.find()) {
                Cookie cookie = Cookie.create(m.group(1), CodecUtils.formDecodeStr(this.stripQuotes(m.group(2))));
                cookies.put(m.group(1), cookie);
            }
        }
        return cookies;
    }

    protected String writeCookie(Cookie cookie) {
        StringBuilder sb = new StringBuilder();
        sb.append(CodecUtils.formEncode(cookie.getName())).append("=").append(CodecUtils.formEncode(cookie.getValue()));
        if (cookie.getDomain() != null) {
            sb.append(";domain=").append(cookie.getDomain());
        }
        if (cookie.getPath() != null) {
            sb.append(";path=").append(cookie.getPath());
        }
        if (cookie.getExpires() != null) {
            sb.append(";expires=").append(HttpDateFormat.RFC822.format(cookie.getExpires()));
        }
        if (cookie.getMaxAge() != null) {
            sb.append(";max-age=").append(cookie.getMaxAge());
        }
        if (cookie.isHttpOnly()) {
            sb.append(";httponly");
        }
        if (cookie.isSecure()) {
            sb.append(";secure");
        }
        return sb.toString();
    }

    protected void cookiesRequest(HttpRequest request) {
        if (request.getCookies() == null) {
            request.setCookies(this.parseCookies(request));
        }
    }

    protected void cookiesResponse(HttpResponse response) {
        Multimap<String, Cookie> cookieMap = response.getCookies();
        if (cookieMap != null) {
            cookieMap.keySet().forEach(key -> response.getHeaders().put("Set-Cookie", this.writeCookie((Cookie)cookieMap.get(key))));
        }
    }

    public HttpResponse handle(HttpRequest request, MiddlewareChain<HttpRequest, NRES, ?, ?> next) {
        this.cookiesRequest(request);
        HttpResponse response = this.castToHttpResponse(next.next((Object)request));
        if (response != null) {
            this.cookiesResponse(response);
        }
        return response;
    }
}

