/*
 * Decompiled with CFR 0.152.
 */
package enkan.middleware;

import enkan.MiddlewareChain;
import enkan.annotation.Middleware;
import enkan.collection.Headers;
import enkan.component.builtin.HmacEncoder;
import enkan.data.ConversationState;
import enkan.data.DefaultConversation;
import enkan.data.HttpRequest;
import enkan.data.HttpResponse;
import enkan.middleware.AbstractWebMiddleware;
import enkan.middleware.session.KeyValueStore;
import enkan.middleware.session.MemoryStore;
import enkan.util.BeanBuilder;
import enkan.util.ThreadingUtils;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Function;
import javax.inject.Inject;

@Middleware(name="conversation")
public class ConversationMiddleware<NRES>
extends AbstractWebMiddleware<HttpRequest, NRES> {
    private KeyValueStore store = new MemoryStore();
    private Function<HttpRequest, String> readTokenFunc = DEFAULT_READ_TOKEN_FUNC;
    @Inject
    private HmacEncoder hmacEncoder;
    private static final Function<HttpRequest, String> DEFAULT_READ_TOKEN_FUNC = request -> ThreadingUtils.some((Object)request, HttpRequest::getFormParams, p -> p.get((Object)"__conversation-token"), Objects::toString).orElse(null);

    private boolean isGetRequest(HttpRequest request) {
        String method = request.getRequestMethod();
        return "GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method) || "OPTIONS".equalsIgnoreCase(method);
    }

    private ConversationToken parseToken(String token) {
        if (token == null) {
            return new ConversationToken(null, "invalid", "0");
        }
        String[] tokens = token.trim().split("\\$", 3);
        if (tokens.length != 3) {
            return new ConversationToken(null, "invalid", "0");
        }
        return new ConversationToken(tokens[0], tokens[1], tokens[2]);
    }

    public HttpResponse handle(HttpRequest request, MiddlewareChain<HttpRequest, NRES, ?, ?> chain) {
        DefaultConversation conversation;
        ConversationToken token = this.parseToken(this.readTokenFunc.apply(request));
        if (!this.isGetRequest(request) && !token.isValid()) {
            return (HttpResponse)BeanBuilder.builder((Object)HttpResponse.of("Invalid conversation.")).set(HttpResponse::setHeaders, (Object)Headers.of("Content-Type", "text/plain")).set(HttpResponse::setStatus, (Object)403).build();
        }
        if (token.id == null) {
            conversation = new DefaultConversation();
        } else {
            conversation = new DefaultConversation(token.id);
            ConversationState state = (ConversationState)this.store.read(token.id);
            request.setConversationState(state);
        }
        request.setConversation(conversation);
        HttpResponse response = this.castToHttpResponse(chain.next((Object)request));
        if (conversation.isTransient()) {
            if (conversation.getId() != null) {
                this.store.delete(conversation.getId());
            }
        } else if (response.getConversationState() != null) {
            this.store.write(conversation.getId(), (Serializable)response.getConversationState());
        }
        return response;
    }

    private class ConversationToken {
        private String id;
        private String hash;
        private long expires;

        ConversationToken(String id, long expires) {
            this.id = id;
            this.hash = ConversationMiddleware.this.hmacEncoder.encodeToHex(id + "$" + expires);
            this.expires = expires;
        }

        ConversationToken(String id, String hash, String expires) {
            this.id = id;
            this.hash = hash;
            try {
                this.expires = Long.valueOf(expires);
            }
            catch (Exception e) {
                this.expires = 0L;
            }
        }

        boolean isValid() {
            return this.id != null && Objects.equals(this.hash, ConversationMiddleware.this.hmacEncoder.encodeToHex(this.id + "$" + this.expires)) && (this.expires < 0L || System.currentTimeMillis() > this.expires);
        }

        public String toString() {
            return this.id + "$" + this.hash + "$" + this.expires;
        }
    }
}

