/*
 * Decompiled with CFR 0.152.
 */
package enkan.middleware;

import enkan.MiddlewareChain;
import enkan.annotation.Middleware;
import enkan.data.HttpRequest;
import enkan.data.HttpResponse;
import enkan.middleware.AbstractWebMiddleware;
import enkan.util.HttpResponseUtils;
import enkan.util.MimeTypeUtils;

@Middleware(name="contentType")
public class ContentTypeMiddleware<NRES>
extends AbstractWebMiddleware<HttpRequest, NRES> {
    protected void contentTypeResponse(HttpResponse response, HttpRequest request) {
        if (HttpResponseUtils.getHeader(response, "Content-Type") == null) {
            String uri = request.getUri();
            String type = MimeTypeUtils.extMimeType((String)uri);
            if (type == null) {
                type = response.getBody() instanceof String ? "text/plain" : "application/octet-stream";
            }
            HttpResponseUtils.contentType(response, type);
        }
    }

    public HttpResponse handle(HttpRequest request, MiddlewareChain<HttpRequest, NRES, ?, ?> chain) {
        HttpResponse response = this.castToHttpResponse(chain.next((Object)request));
        if (response != null) {
            this.contentTypeResponse(response, request);
        }
        return response;
    }
}

