/*
 * Decompiled with CFR 0.152.
 */
package enkan.middleware;

import enkan.MiddlewareChain;
import enkan.annotation.Middleware;
import enkan.data.ContentNegotiable;
import enkan.data.HttpRequest;
import enkan.data.HttpResponse;
import enkan.middleware.AbstractWebMiddleware;
import enkan.middleware.negotiation.AcceptHeaderNegotiator;
import enkan.middleware.negotiation.ContentNegotiator;
import enkan.util.MixinUtils;
import enkan.util.ThreadingUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.ws.rs.core.MediaType;

@Middleware(name="contentNegotiation")
public class ContentNegotiationMiddleware<NRES>
extends AbstractWebMiddleware<HttpRequest, NRES> {
    private ContentNegotiator negotiator = new AcceptHeaderNegotiator();
    private Set<String> allowedTypes = new HashSet<String>(Collections.singletonList("text/html"));
    private Set<String> allowedLanguages = new HashSet<String>(Collections.singletonList("*"));

    public HttpResponse handle(HttpRequest request, MiddlewareChain<HttpRequest, NRES, ?, ?> chain) {
        String accept = (String)request.getHeaders().getOrDefault("Accept", "*/*");
        MediaType mediaType = this.negotiator.bestAllowedContentType(accept, this.allowedTypes);
        String acceptLanguage = (String)request.getHeaders().getOrDefault("Accept-Language", "*");
        String lang = this.negotiator.bestAllowedLanguage(acceptLanguage, this.allowedLanguages);
        Locale locale = Objects.equals(lang, "*") ? null : (Locale)ThreadingUtils.some((Object)lang, Locale::forLanguageTag).orElse(null);
        request = (HttpRequest)MixinUtils.mixin((Object)request, (Class[])new Class[]{ContentNegotiable.class});
        ((ContentNegotiable)ContentNegotiable.class.cast(request)).setMediaType(mediaType);
        ((ContentNegotiable)ContentNegotiable.class.cast(request)).setLocale(locale);
        return this.castToHttpResponse(chain.next((Object)request));
    }

    public void setNegotiator(ContentNegotiator negotiator) {
        this.negotiator = negotiator;
    }

    public void setAllowedTypes(Set<String> allowedTypes) {
        this.allowedTypes = allowedTypes;
    }

    public void setAllowedLanguages(Set<String> allowedLanguages) {
        this.allowedLanguages = allowedLanguages;
    }
}

