/*
 * Decompiled with CFR 0.152.
 */
package enkan.middleware;

import enkan.MiddlewareChain;
import enkan.annotation.Middleware;
import enkan.collection.Headers;
import enkan.data.ForgeryDetectable;
import enkan.data.HttpRequest;
import enkan.data.HttpResponse;
import enkan.data.Session;
import enkan.data.SessionAvailable;
import enkan.middleware.AbstractWebMiddleware;
import enkan.util.BeanBuilder;
import enkan.util.MixinUtils;
import enkan.util.ThreadingUtils;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

@Middleware(name="antiForgery", dependencies={"session"})
public class AntiForgeryMiddleware<NRES>
extends AbstractWebMiddleware<HttpRequest, NRES> {
    private static final String TOKEN_KEY = AntiForgeryMiddleware.class.getName() + "/antiForgeryToken";

    private String newToken() {
        return UUID.randomUUID().toString();
    }

    protected Optional<String> sessionToken(HttpRequest request) {
        return ThreadingUtils.some((Object)request, SessionAvailable::getSession, s -> s.get((Object)TOKEN_KEY), Objects::toString);
    }

    protected void putSessionToken(HttpResponse response, HttpRequest request, String token) {
        String oldToken = this.sessionToken(request).orElse(null);
        if (!Objects.equals(token, oldToken)) {
            Session session = Optional.ofNullable(request.getSession()).orElse(new Session());
            session.put(TOKEN_KEY, (Serializable)((Object)token));
            response.setSession(session);
        }
    }

    private Map<String, ?> formParams(HttpRequest request) {
        return request.getParams();
    }

    private Optional<String> defaultRequestToken(HttpRequest request) {
        return ThreadingUtils.some((Object)request, this::formParams, p -> p.get("__anti-forgery-token"), Object::toString);
    }

    private boolean isValidRequest(HttpRequest request) {
        Optional<String> readToken = this.defaultRequestToken(request);
        Optional<String> storedToken = this.sessionToken(request);
        return readToken.isPresent() && storedToken.isPresent() && readToken.get().equals(storedToken.get());
    }

    private boolean isGetRequest(HttpRequest request) {
        String method = request.getRequestMethod();
        return "GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method) || "OPTIONS".equalsIgnoreCase(method);
    }

    public HttpResponse handle(HttpRequest request, MiddlewareChain<HttpRequest, NRES, ?, ?> next) {
        String token = this.sessionToken(request).orElseGet(this::newToken);
        if (!this.isGetRequest(request) && !this.isValidRequest(request)) {
            return (HttpResponse)BeanBuilder.builder((Object)HttpResponse.of("<h1>Invalid anti-forgery token</h1>")).set(HttpResponse::setStatus, (Object)403).set(HttpResponse::setHeaders, (Object)Headers.of("Content-Type", "text/html")).build();
        }
        request = (HttpRequest)MixinUtils.mixin((Object)request, (Class[])new Class[]{ForgeryDetectable.class});
        ((ForgeryDetectable)ForgeryDetectable.class.cast(request)).setAntiForgeryToken(token);
        HttpResponse response = this.castToHttpResponse(next.next((Object)request));
        this.putSessionToken(response, request, token);
        return response;
    }
}

