/*
 * Decompiled with CFR 0.152.
 */
package enkan.middleware;

import enkan.MiddlewareChain;
import enkan.annotation.Middleware;
import enkan.data.HttpRequest;
import enkan.data.HttpResponse;
import enkan.middleware.AbstractWebMiddleware;
import enkan.util.HttpRequestUtils;
import enkan.util.ThreadingUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

@Middleware(name="absoluteRedirect")
public class AbsoluteRedirectsMiddleware<NRES>
extends AbstractWebMiddleware<HttpRequest, NRES> {
    private static final Set<Integer> REDIRECT_STATUS = new HashSet<Integer>(Arrays.asList(201, 301, 302, 303, 307));

    protected boolean isRedirectResponse(HttpResponse response) {
        return REDIRECT_STATUS.contains(response.getStatus());
    }

    protected void updateHeader(HttpResponse response, String header, HttpRequest request) {
        ThreadingUtils.some((Object)response.getHeaders().get(header), Object::toString).ifPresent(url -> response.getHeaders().replace(header, this.absoluteUrl((String)url, request)));
    }

    protected boolean isUrl(String s) {
        try {
            new URL(s);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    protected String absoluteUrl(String location, HttpRequest request) {
        if (this.isUrl(location)) {
            return location;
        }
        try {
            URL url = new URL(HttpRequestUtils.requestUrl(request));
            return new URL(url, location).toString();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(String.format("wrong location %s or request url %s.", location, HttpRequestUtils.requestUrl(request)), e);
        }
    }

    public HttpResponse handle(HttpRequest request, MiddlewareChain<HttpRequest, NRES, ?, ?> chain) {
        HttpResponse response = this.castToHttpResponse(chain.next((Object)request));
        if (this.isRedirectResponse(response)) {
            this.updateHeader(response, "location", request);
        }
        return response;
    }
}

