/*
 * Decompiled with CFR 0.152.
 */
package enkan.data;

import enkan.collection.Headers;
import enkan.collection.Multimap;
import enkan.data.Cookie;
import enkan.data.HttpResponse;
import enkan.data.PersistentMarkedSession;
import enkan.data.Session;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class DefaultHttpResponse
implements HttpResponse {
    private int status;
    private Headers headers;
    private Multimap<String, Cookie> cookies;
    private Session session;
    private String bodyString;
    private InputStream bodyStream;
    private File bodyFile;
    private final Map<String, Object> extensions;

    protected DefaultHttpResponse(int status, Headers headers) {
        this.status = status;
        this.headers = headers;
        this.cookies = Multimap.empty();
        this.extensions = new HashMap<String, Object>();
        this.session = new PersistentMarkedSession();
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public Headers getHeaders() {
        return this.headers;
    }

    @Override
    public void setHeaders(Headers headers) {
        this.headers = headers;
    }

    @Override
    public Multimap<String, Cookie> getCookies() {
        return this.cookies;
    }

    @Override
    public void setCookies(Multimap<String, Cookie> cookies) {
        this.cookies = cookies;
    }

    @Override
    public Object getBody() {
        if (this.bodyString != null) {
            return this.bodyString;
        }
        if (this.bodyStream != null) {
            return this.bodyStream;
        }
        if (this.bodyFile != null) {
            return this.bodyFile;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream getBodyAsStream() {
        if (this.bodyStream != null) {
            return this.bodyStream;
        }
        if (this.bodyString != null) {
            return new ByteArrayInputStream(this.bodyString.getBytes(StandardCharsets.UTF_8));
        }
        if (this.bodyFile == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        try {
            FileInputStream fileInputStream;
            FileInputStream in = new FileInputStream(this.bodyFile);
            Throwable throwable = null;
            try {
                fileInputStream = in;
            }
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    DefaultHttpResponse.$closeResource(throwable, in);
                    throw throwable3;
                }
            }
            DefaultHttpResponse.$closeResource(throwable, in);
            return fileInputStream;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public String getBodyAsString() {
        if (this.bodyStream != null) {
            String string;
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.bodyStream));
            Throwable throwable = null;
            try {
                string = reader.lines().collect(Collectors.joining(System.lineSeparator()));
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        DefaultHttpResponse.$closeResource(throwable, reader);
                        throw throwable3;
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            DefaultHttpResponse.$closeResource(throwable, reader);
            return string;
        }
        if (this.bodyString != null) {
            return this.bodyString;
        }
        if (this.bodyFile != null) {
            String string;
            BufferedReader reader = new BufferedReader(new FileReader(this.bodyFile));
            Throwable throwable = null;
            try {
                string = reader.lines().collect(Collectors.joining(System.lineSeparator()));
            }
            catch (Throwable throwable4) {
                try {
                    try {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        DefaultHttpResponse.$closeResource(throwable, reader);
                        throw throwable5;
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            DefaultHttpResponse.$closeResource(throwable, reader);
            return string;
        }
        return "";
    }

    @Override
    public void setBody(String body) {
        this.bodyString = body;
    }

    @Override
    public void setBody(InputStream body) {
        this.bodyStream = body;
    }

    @Override
    public void setBody(File body) {
        this.bodyFile = body;
    }

    public String toString() {
        String b = this.bodyStream != null ? this.bodyStream.toString() : (this.bodyFile != null ? this.bodyFile.toString() : this.bodyString);
        return "{status=" + this.status + ", headers=" + Objects.toString(this.headers.toString(), "{}") + ", body=" + b + "}";
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public <T> T getExtension(String name) {
        return (T)this.extensions.get(name);
    }

    public <T> void setExtension(String name, T extension) {
        this.extensions.put(name, extension);
    }
}

