/*
 * Decompiled with CFR 0.152.
 */
package enkan.application;

import enkan.Application;
import enkan.Middleware;
import enkan.MiddlewareChain;
import enkan.chain.DefaultMiddlewareChain;
import enkan.data.HttpRequest;
import enkan.data.HttpResponse;
import enkan.data.UriAvailable;
import enkan.predicate.PathPredicate;
import enkan.util.Predicates;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;

public class WebApplication
implements Application<HttpRequest, HttpResponse> {
    private final LinkedList<MiddlewareChain<?, ?, ?, ?>> middlewareStack = new LinkedList();

    public <REQ extends UriAvailable, RES, NREQ, NRES> void get(String path, Middleware<REQ, RES, NREQ, NRES> middleware) {
        this.use((Predicate)PathPredicate.GET((String)path), middleware);
    }

    public <REQ extends UriAvailable, RES, NREQ, NRES> void post(String path, Middleware<REQ, RES, NREQ, NRES> middleware) {
        this.use((Predicate)PathPredicate.POST((String)path), middleware);
    }

    public <REQ extends UriAvailable, RES, NREQ, NRES> void put(String path, Middleware<REQ, RES, NREQ, NRES> middleware) {
        this.use((Predicate)PathPredicate.PUT((String)path), middleware);
    }

    public <REQ extends UriAvailable, RES, NREQ, NRES> void delete(String path, Middleware<REQ, RES, NREQ, NRES> middleware) {
        this.use((Predicate)PathPredicate.DELETE((String)path), middleware);
    }

    public <REQ, RES, NREQ, NRES> void use(Predicate<? super REQ> decision, String middlewareName, Middleware<REQ, RES, NREQ, NRES> middleware) {
        DefaultMiddlewareChain chain = new DefaultMiddlewareChain(decision, middlewareName, middleware);
        if (!this.middlewareStack.isEmpty()) {
            this.middlewareStack.getLast().setNext(this.cast((MiddlewareChain)chain));
        }
        this.middlewareStack.addLast((MiddlewareChain<?, ?, ?, ?>)chain);
    }

    public HttpResponse handle(HttpRequest req) {
        return (HttpResponse)new DefaultMiddlewareChain(Predicates.any(), "bootstrap", (req1, chain) -> (HttpResponse)chain.next(req1)).setNext(this.cast(this.middlewareStack.getFirst())).next((Object)req);
    }

    public List<MiddlewareChain<?, ?, ?, ?>> getMiddlewareStack() {
        return this.middlewareStack;
    }

    private <REQ, RES> MiddlewareChain<REQ, RES, ?, ?> cast(MiddlewareChain chain) {
        return chain;
    }
}

