/*
 * Decompiled with CFR 0.152.
 */
package enkan.throttling;

import enkan.throttling.RefillStrategy;
import enkan.throttling.SleepStrategy;
import java.util.concurrent.TimeUnit;

public class TokenBucket {
    private final long capacity;
    private final RefillStrategy refillStrategy;
    private final SleepStrategy sleepStrategy;
    private long size;

    public TokenBucket(long capacity, long initialTokens, RefillStrategy refillStrategy, SleepStrategy sleepStrategy) {
        this.capacity = capacity;
        this.refillStrategy = refillStrategy;
        this.sleepStrategy = sleepStrategy;
        this.size = initialTokens;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public synchronized long getNumTokens() {
        this.refill(this.refillStrategy.refill());
        return this.size;
    }

    public long getDurationUntilNextRefill(TimeUnit unit) throws UnsupportedOperationException {
        return this.refillStrategy.getDurationUntilNextRefill(unit);
    }

    public boolean tryConsume() {
        return this.tryConsume(1L);
    }

    public synchronized boolean tryConsume(long numTokens) {
        if (numTokens <= 0L) {
            throw new IllegalArgumentException("Number of tokens to consume must be positive");
        }
        if (numTokens > this.capacity) {
            throw new IllegalArgumentException("Number of tokens to consume must be less than the capacity of the bucket.");
        }
        this.refill(this.refillStrategy.refill());
        if (numTokens <= this.size) {
            this.size -= numTokens;
            return true;
        }
        return false;
    }

    public void consume() {
        this.consume(1L);
    }

    public void consume(long numTokens) {
        while (!this.tryConsume(numTokens)) {
            this.sleepStrategy.sleep();
        }
    }

    public synchronized void refill(long numTokens) {
        long newTokens = Math.min(this.capacity, Math.max(0L, numTokens));
        this.size = Math.max(0L, Math.min(this.size + newTokens, this.capacity));
    }
}

