/*
 * Decompiled with CFR 0.152.
 */
package enkan.throttling;

import enkan.data.HttpRequest;
import enkan.throttling.LimitRate;
import enkan.throttling.RefillStrategy;
import enkan.throttling.TokenBucket;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class Throttle {
    private final Function<HttpRequest, Object> discriminateFn;
    private final String name;
    private final LimitRate limitRate;
    private final Map<Object, TokenBucket> buckets;

    public Throttle(String name, LimitRate limitRate, Function<HttpRequest, Object> discriminateFn) {
        this.name = name;
        this.limitRate = limitRate;
        this.discriminateFn = discriminateFn;
        this.buckets = new ConcurrentHashMap<Object, TokenBucket>();
    }

    public boolean apply(HttpRequest request) {
        Object discriminator = this.discriminateFn.apply(request);
        if (discriminator == null) {
            return false;
        }
        TokenBucket bucket = this.buckets.computeIfAbsent(discriminator, key -> new TokenBucket(this.limitRate.getMax(), this.limitRate.getMax(), new RefillStrategy(this.limitRate.getMax(), this.limitRate.getDuration()), () -> {
            boolean interrupted = false;
            try {
                TimeUnit.NANOSECONDS.sleep(1L);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }));
        if (bucket.tryConsume(1L)) {
            bucket.consume();
            return false;
        }
        return true;
    }
}

