/*
 * Decompiled with CFR 0.152.
 */
package enkan.throttling;

import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class RefillStrategy {
    private final long numTokensPerPeriod;
    private final long periodDurationInNanos;
    private long lastRefillTime;
    private long nextRefillTime;

    public RefillStrategy(long numTokensPerPeriod, Duration duration) {
        this.numTokensPerPeriod = numTokensPerPeriod;
        this.periodDurationInNanos = duration.toNanos();
        this.lastRefillTime = -this.periodDurationInNanos;
        this.nextRefillTime = -this.periodDurationInNanos;
    }

    public synchronized long refill() {
        long now = System.nanoTime();
        if (now < this.nextRefillTime) {
            return 0L;
        }
        long numPeriods = Math.max(0L, (now - this.lastRefillTime) / this.periodDurationInNanos);
        this.lastRefillTime += numPeriods * this.periodDurationInNanos;
        this.nextRefillTime = this.lastRefillTime + this.periodDurationInNanos;
        return numPeriods * this.numTokensPerPeriod;
    }

    public long getDurationUntilNextRefill(TimeUnit unit) {
        long now = System.nanoTime();
        return unit.convert(Math.max(0L, this.nextRefillTime - now), TimeUnit.NANOSECONDS);
    }
}

