/*
 * Decompiled with CFR 0.152.
 */
package enkan.middleware.throttling;

import enkan.MiddlewareChain;
import enkan.annotation.Middleware;
import enkan.data.HttpRequest;
import enkan.data.HttpResponse;
import enkan.middleware.AbstractWebMiddleware;
import enkan.throttling.Throttle;
import enkan.util.BeanBuilder;
import enkan.util.HttpResponseUtils;
import java.util.Collections;
import java.util.List;

@Middleware(name="throttling")
public class ThrottlingMiddleware
extends AbstractWebMiddleware {
    private List<Throttle> throttles = Collections.emptyList();

    public HttpResponse handle(HttpRequest request, MiddlewareChain chain) {
        if (this.throttles.stream().anyMatch(throttle -> throttle.apply(request))) {
            return (HttpResponse)BeanBuilder.builder((Object)HttpResponseUtils.response((String)"Too Many Request")).set(HttpResponse::setStatus, (Object)429).build();
        }
        return this.castToHttpResponse(chain.next((Object)request));
    }

    public void setThrottles(List<Throttle> throttles) {
        this.throttles = throttles;
    }
}

