/*
 * Decompiled with CFR 0.152.
 */
package enkan.system.devel.compiler;

import enkan.Env;
import enkan.system.ReplResponse;
import enkan.system.Transport;
import enkan.system.devel.CompileResult;
import enkan.system.devel.Compiler;
import java.io.File;
import java.util.Collections;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.codehaus.plexus.util.cli.CommandLineException;

public class MavenCompiler
implements Compiler {
    private String projectDirectory = ".";

    @Override
    public CompileResult execute(Transport t) {
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setPomFile(new File("pom.xml"));
        request.setGoals(Collections.singletonList("compile"));
        DefaultInvoker invoker = new DefaultInvoker();
        File mavenHome = new File(Env.getString((String)"MAVEN_HOME", (String)Env.getString((String)"M2_HOME", (String)"/opt/maven")));
        if (!mavenHome.exists()) {
            throw new IllegalStateException("MAVEN_HOME not set");
        }
        invoker.setWorkingDirectory(new File(this.projectDirectory));
        invoker.setMavenHome(mavenHome);
        invoker.setOutputHandler(line -> t.send(ReplResponse.withOut((String)line)));
        invoker.setErrorHandler(line -> t.send(ReplResponse.withErr((String)line)));
        CompileResult result = new CompileResult();
        try {
            InvocationResult invocationResult = invoker.execute((InvocationRequest)request);
            CommandLineException clEx = invocationResult.getExecutionException();
            result.setExecutionException((Throwable)clEx);
        }
        catch (MavenInvocationException ex) {
            result.setExecutionException(ex);
        }
        return result;
    }

    public void setProjectDirectory(String projectDirectory) {
        this.projectDirectory = projectDirectory;
    }
}

